% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp_directions.R
\name{mp_directions}
\alias{mp_directions}
\title{Get directions from the Google Maps Directions API}
\usage{
mp_directions(origin, destination, mode = c("driving", "transit", "walking",
  "bicycling"), arrival_time = NULL, departure_time = NULL,
  alternatives = FALSE, avoid = NULL, region = NULL, key = NULL)
}
\arguments{
\item{origin}{Origin, as \itemize{
\item{\code{character} vector of length one with address to be geocoded}
\item{\code{numeric} vector of length two (lon, lat)}
\item{\code{matrix} with one row and two columns (lon, lat)}
\item{\code{sf} or \code{sfc} point layer with one feature}
}}

\item{destination}{Destination, in one of the same formats as for \code{origins}}

\item{mode}{Travel mode, one of: \code{"driving"} (default), \code{"transit"}, \code{"walking"}, \code{"bicycling"}}

\item{arrival_time}{The desired time of arrival for transit directions, as \code{POSIXct}}

\item{departure_time}{The desired time of departure, as \code{POSIXct}}

\item{alternatives}{Whether to return more than one alternative (\code{logical})}

\item{avoid}{\code{NULL} (default) or one of: \code{"tolls"}, \code{"highways"}, \code{"ferries"} or \code{"indoor"}}

\item{region}{The region code, specified as a ccTLD ("top-level domain") two-character value (e.g. \code{"es"} for Spain) (optional)}

\item{key}{Google APIs key (optional)}
}
\value{
XML document with Google Maps Directions API response
}
\description{
Get directions from the Google Maps Directions API
}
\note{
Functions \code{\link{mp_get_routes}} and \code{\link{mp_get_segments}} can be used to extract routes as \code{sf} line layers from returned object
}
\examples{
# Built-in reponse example
library(xml2)
doc = as_xml_document(response_directions_driving)
r = mp_get_routes(doc)
seg = mp_get_segments(doc)
\dontrun{
# Using 'numeric' input
doc = mp_directions(
  origin = c(34.81127, 31.89277),
  destination = c(34.781107, 32.085003),
  alternatives = TRUE
)
# Using 'character' and 'sf' input
library(magrittr); library(sf)
doc = mp_directions(
  origin = "Beer-Sheva",
  destination = c(34.781107, 32.085003) \%>\% st_point \%>\% st_sfc(crs = 4326),
  alternatives = TRUE
)
}
}
