% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp_get_bounds.R
\name{mp_get_bounds}
\alias{mp_get_bounds}
\title{Extract geocoded *bounds* from Google Maps Geocode API response}
\usage{
mp_get_bounds(doc)
}
\arguments{
\item{doc}{XML document with Google Maps Geocode API response}
}
\value{
\code{sf} Polygonal layer representing bounds of geocoded locations
}
\description{
Extract geocoded *bounds* from Google Maps Geocode API response
}
\examples{
library(xml2)
doc = list("Tel-Aviv" = as_xml_document(response_geocode))
b = mp_get_bounds(doc)
\dontrun{
doc = mp_geocode(addresses = c("Tel-Aviv", "Rehovot", "Beer-Sheva"))
b = mp_get_bounds(doc)
}
}
