% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extent.R
\name{viewExtent}
\alias{viewExtent}
\alias{viewExtent,addExtent}
\alias{viewExtent}
\alias{addExtent}
\title{View extent/bbox of spatial objects interactively}
\usage{
viewExtent(x, map = NULL, popup = NULL, layer.name = NULL,
  alpha.regions = 0.2, label = NULL, ...)

addExtent(map, data, ...)
}
\arguments{
\item{x}{either a Raster*, sf* or Spatial* object}

\item{map}{a leaflet map the extent should be added to. If NULL
standard background layers are created.}

\item{popup}{a \code{list} of HTML strings with the popup contents, usually
created from \code{\link{popupTable}}. See \code{\link{addControl}} for
details.}

\item{layer.name}{the name of the layer to be shown on the map.}

\item{alpha.regions}{opacity of the fills or the raster layer(s).}

\item{label}{a character vector of labels to be shown on mouseover. See
\code{\link{addControl}} for details.}

\item{...}{additional arguments passed on to \code{\link{addRectangles}}}

\item{data}{either a Raster*, sf* or Spatial* object}
}
\description{
This function produces an interactive view of the extent/bbox
of the supplied spatial object
}
\section{Functions}{
\itemize{
\item \code{addExtent}: add extent/bbox of spatial/sf objects to a leaflet map
}}

\examples{
\dontrun{
viewExtent(poppendorf)
viewExtent(breweries)
viewExtent(franconia) + breweries
viewExtent(trails) + trails + breweries
leaflet() \%>\% addProviderTiles("OpenStreetMap") \%>\% addExtent(breweries)
}

}
\author{
Tim Appelhans
}
