% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{file_copy_md5}
\alias{file_copy_md5}
\title{File copy with md5 hash check}
\usage{
file_copy_md5(path, new_path, overwrite = NA, quiet = FALSE)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{new_path}{A character vector of paths to the new locations.}

\item{overwrite}{When \code{NA}, only saves if the md5 hashes do not match.
Otherwise, see \code{\link[fs:copy]{fs::file_copy()}}.}

\item{quiet}{When \code{TRUE}, suppresses messages from md5 checks.}
}
\value{
The path(s) of the new file(s), invisibly.  When \code{overwrite} is
\code{NA}, the paths will be returned with two addition attributes, \code{"changed"},
a logical vector indicating whether the file was changed (\code{NA} for when the
file is new), and \code{"md5sum"}, a list of the md5sums of the old and new md5
sums.
}
\description{
File copy with md5 hash check
}
