% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.markovMSM.R
\name{plot.markovMSM}
\alias{plot.markovMSM}
\title{Plot for an object of class "markovMSM"}
\usage{
\method{plot}{markovMSM}(x = object, to=2, quantileOrder = NULL, 
axis.scale = c(-1, 1), difP = FALSE, ...)
}
\arguments{
\item{x}{A dataframe in long format in case of the plot with the differences
between AJ and LMAJ estimators or a object of class "markovMSM" with the
results of the global.test or local.test function.}

\item{to}{The last receiving state considered for the estimation of the
transition probabilities. Plot of the transition probabilities between the 
starting to this state is shown.}

\item{quantileOrder}{Order of the quantil used in the formula of the AUC
global test.}

\item{axis.scale}{Limit of the y axis of the plots.}

\item{difP}{Type of plot representing in case of x means the results of the
Localtest. If difP=TRUE plot depicts the discrepancies between AJ and LMAJ
estimators.  If difP=FALSE plot show the AJ and the LMAJ estimates. 
By default difP=FALSE.}

\item{...}{For future methods.}
}
\value{
No value is returned.
}
\description{
Plots for the visual inspection for checking the Markov 
condition through the difference between the AJ and LMAJ from a starting
time of the transition probabilities for each transition.
}
\examples{
library(markovMSM)
data(prothr)
\donttest{
res<-AUC.test(db_long=prothr, times=30, from=1, to=3, type='local', 
replicas=10)

plot(res, to=3, axis.scale=c(-0.25,.25), difP=TRUE)
plot(res, to=2, axis.scale=c(0,.25), difP=FALSE)

res2<-AUC.test(db_long=prothr, db_wide = NULL, from=1, to=3, 
type='global', replicas=10, limit=0.90, quantiles=c(.05, .10, .20, .30, 0.40))
plot(res2, quantileOrder=3, 2, axis.scale=c(-0.05,.15))
}
}
\references{
Soutinho G, Meira-Machado L (2021). Methods for checking the 
Markov condition in multi-state survival data. \emph{Computational Statistics}.
}
\author{
Gustavo Soutinho and Luis Meira-Machado.
}
