/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class MaxOfAList
extends AbstractLargeIntSConstraint {
    public static final int MAX_INDEX = 0;
    public static final int VARS_OFFSET = 1;
    protected final IStateInt indexOfMaximumVariable;

    public MaxOfAList(IEnvironment environment, IntDomainVar[] vars) {
        super(ConstraintEvent.LINEAR, vars);
        this.indexOfMaximumVariable = environment.makeInt(-1);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 11;
    }

    protected void onlyOneMaxCandidatePropagation() throws ContradictionException {
        int idx;
        int nbVars = ((IntDomainVar[])this.vars).length;
        IntDomainVar maxVar = ((IntDomainVar[])this.vars)[0];
        if (this.indexOfMaximumVariable.get() == -1) {
            int maxMax = Integer.MIN_VALUE;
            int maxMaxIdx = -1;
            int maxMax2 = Integer.MIN_VALUE;
            int maxMax2Idx = -1;
            for (int i = 1; i < nbVars; ++i) {
                int val = ((IntDomainVar[])this.vars)[i].getSup();
                if (val >= maxMax) {
                    maxMax2 = maxMax;
                    maxMax2Idx = maxMaxIdx;
                    maxMax = val;
                    maxMaxIdx = i;
                    continue;
                }
                if (val <= maxMax2) continue;
                maxMax2 = val;
                maxMax2Idx = i;
            }
            if (maxMax2 < maxVar.getInf()) {
                this.indexOfMaximumVariable.set(maxMaxIdx);
            }
        }
        if ((idx = this.indexOfMaximumVariable.get()) != -1) {
            maxVar.updateInf(((IntDomainVar[])this.vars)[idx].getInf(), this, false);
            ((IntDomainVar[])this.vars)[idx].updateInf(maxVar.getInf(), this, false);
        }
    }

    protected boolean testIfOneCandidateToTakeMaxValue() {
        int maxValue = ((IntDomainVar[])this.vars)[0].getVal();
        int nbVars = ((IntDomainVar[])this.vars).length;
        boolean existsInstantiated = false;
        for (int i = 1; i < nbVars; ++i) {
            if (((IntDomainVar[])this.vars)[i].getSup() >= maxValue) {
                return false;
            }
            if (((IntDomainVar[])this.vars)[i].getInf() != maxValue) continue;
            existsInstantiated = true;
        }
        return existsInstantiated;
    }

    protected final int maxInf() {
        int nbVars = ((IntDomainVar[])this.vars).length;
        int max = Integer.MIN_VALUE;
        for (int i = 1; i < nbVars; ++i) {
            int val = ((IntDomainVar[])this.vars)[i].getInf();
            if (val <= max) continue;
            max = val;
        }
        return max;
    }

    protected final int maxSup() {
        int nbVars = ((IntDomainVar[])this.vars).length;
        int max = Integer.MIN_VALUE;
        for (int i = 1; i < nbVars; ++i) {
            int val = ((IntDomainVar[])this.vars)[i].getSup();
            if (val <= max) continue;
            max = val;
        }
        return max;
    }

    @Override
    public void propagate() throws ContradictionException {
        int nbVars = ((IntDomainVar[])this.vars).length;
        IntDomainVar maxVar = ((IntDomainVar[])this.vars)[0];
        maxVar.updateInf(this.maxInf(), this, false);
        maxVar.updateSup(this.maxSup(), this, false);
        int maxValue = maxVar.getSup();
        for (int i = 1; i < nbVars; ++i) {
            ((IntDomainVar[])this.vars)[i].updateSup(maxValue, this, false);
        }
        this.onlyOneMaxCandidatePropagation();
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx >= 1) {
            ((IntDomainVar[])this.vars)[0].updateInf(this.maxInf(), this, false);
        } else {
            this.onlyOneMaxCandidatePropagation();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx >= 1) {
            ((IntDomainVar[])this.vars)[0].updateSup(this.maxSup(), this, false);
            this.onlyOneMaxCandidatePropagation();
        } else {
            int nbVars = ((IntDomainVar[])this.vars).length;
            int maxVal = ((IntDomainVar[])this.vars)[0].getSup();
            for (int i = 1; i < nbVars; ++i) {
                ((IntDomainVar[])this.vars)[i].updateSup(maxVal, this, false);
            }
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx >= 1) {
            IntDomainVar maxVar = ((IntDomainVar[])this.vars)[0];
            maxVar.updateInf(this.maxInf(), this, false);
            maxVar.updateSup(this.maxSup(), this, false);
        } else {
            int nbVars = ((IntDomainVar[])this.vars).length;
            int maxValue = ((IntDomainVar[])this.vars)[0].getSup();
            for (int i = 1; i < nbVars; ++i) {
                ((IntDomainVar[])this.vars)[i].updateSup(maxValue, this, false);
            }
            this.onlyOneMaxCandidatePropagation();
        }
    }

    @Override
    public Boolean isEntailed() {
        int maxInf = ((IntDomainVar[])this.vars)[0].getInf();
        int maxSup = ((IntDomainVar[])this.vars)[0].getSup();
        int cptIn = 0;
        int cptAbove = 0;
        for (int i = 1; i < ((IntDomainVar[])this.vars).length; ++i) {
            IntDomainVar tmp = ((IntDomainVar[])this.vars)[i];
            int inf = tmp.getInf();
            int sup = tmp.getSup();
            if (inf == maxInf && maxSup == sup && inf == sup) {
                ++cptIn;
                continue;
            }
            if (inf > maxSup) {
                return Boolean.FALSE;
            }
            if (sup >= maxInf) continue;
            ++cptAbove;
        }
        if (cptAbove == ((IntDomainVar[])this.vars).length - 1) {
            return Boolean.FALSE;
        }
        if (cptIn > 0) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int maxValue = Integer.MIN_VALUE;
        for (int i = 1; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (maxValue >= tuple[i]) continue;
            maxValue = tuple[i];
        }
        return tuple[0] == maxValue;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append(((IntDomainVar[])this.vars)[0].pretty()).append(" = max({");
        for (int i = 1; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (i > 1) {
                sb.append(", ");
            }
            sb.append(((IntDomainVar[])this.vars)[i].pretty());
        }
        sb.append("})");
        return sb.toString();
    }
}

