/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search;

import choco.cp.solver.search.restart.IKickRestart;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.branch.AbstractBranchingStrategy;
import choco.kernel.solver.branch.AbstractIntBranchingStrategy;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.AbstractSearchLoop;
import choco.kernel.solver.search.IntBranchingTrace;
import java.util.logging.Level;

public abstract class AbstractSearchLoopWithRestart
extends AbstractSearchLoop {
    protected int moveAfterSolution = 2;
    protected int previousNbSolutions;
    protected IKickRestart kickRestart;
    protected IntBranchingTrace ctx = null;
    protected AbstractBranchingStrategy br;
    protected Object branchingObj;
    protected AbstractIntBranchingStrategy currentBranching;

    public AbstractSearchLoopWithRestart(AbstractGlobalSearchStrategy searchStrategy, IKickRestart kickRestart) {
        super(searchStrategy);
        this.kickRestart = kickRestart;
    }

    public final IntBranchingTrace getCurrentTrace() {
        return this.ctx;
    }

    public final IKickRestart getKickRestart() {
        return this.kickRestart;
    }

    public final void setRestartAfterEachSolution(boolean restart) {
        this.moveAfterSolution = restart ? 8 : 2;
    }

    public final void setKickRestart(IKickRestart kickRestart) {
        this.kickRestart = kickRestart;
    }

    @Override
    public void initialize() {
        this.previousNbSolutions = 0;
        super.initialize();
    }

    @Override
    public void initSearch() {
        this.br = this.searchStrategy.mainGoal;
        while (this.br != null) {
            this.br.initBranching();
            this.br = this.br.getNextBranching();
        }
        this.searchStrategy.nextMove = 1;
    }

    @Override
    public void initLoop() {
        this.previousNbSolutions = this.searchStrategy.getSolutionCount();
        this.searchStrategy.setEncounteredLimit(null);
        this.ctx = this.searchStrategy.initialTrace();
    }

    @Override
    public Boolean endLoop() {
        this.searchStrategy.limitManager.reset();
        if (this.searchStrategy.getSolutionCount() > this.previousNbSolutions) {
            return Boolean.TRUE;
        }
        if (this.searchStrategy.isEncounteredLimit()) {
            return null;
        }
        return Boolean.FALSE;
    }

    @Override
    public void openNode() {
        try {
            this.searchStrategy.limitManager.newNode();
            this.currentBranching = this.ctx.getBranching();
            while (this.currentBranching != null) {
                this.branchingObj = this.currentBranching.selectBranchingObject();
                if (this.branchingObj == null) {
                    this.currentBranching = (AbstractIntBranchingStrategy)this.currentBranching.getNextBranching();
                    continue;
                }
                this.ctx = this.searchStrategy.pushTrace();
                this.ctx.setBranching(this.currentBranching);
                this.ctx.setBranchingObject(this.branchingObj);
                this.currentBranching.setFirstBranch(this.ctx);
                this.searchStrategy.nextMove = 4;
                return;
            }
            this.searchStrategy.nextMove = this.moveAfterSolution;
            this.stop = true;
            this.searchStrategy.recordSolution();
        }
        catch (ContradictionException e) {
            this.searchStrategy.nextMove = e.getContradictionMove();
        }
    }

    protected abstract void worldPop();

    protected void goUpBranch() throws ContradictionException {
        this.searchStrategy.postDynamicCut();
        this.ctx.getBranching().goUpBranch(this.ctx);
        this.searchStrategy.solver.propagate();
    }

    @Override
    public void upBranch() {
        try {
            this.searchStrategy.limitManager.endNode();
            this.worldPop();
            this.goUpBranch();
            if (!this.ctx.getBranching().finishedBranching(this.ctx)) {
                this.ctx.getBranching().setNextBranch(this.ctx);
                this.ctx.incrementBranchIndex();
                this.searchStrategy.nextMove = 4;
            } else {
                this.ctx = this.searchStrategy.popTrace();
                this.searchStrategy.nextMove = 2;
            }
        }
        catch (ContradictionException e) {
            this.ctx = this.searchStrategy.popTrace();
            this.searchStrategy.nextMove = e.getContradictionMove();
        }
    }

    protected abstract void worldPush();

    @Override
    public void downBranch() {
        try {
            this.worldPush();
            this.ctx.getBranching().goDownBranch(this.ctx);
            this.searchStrategy.solver.propagate();
            this.searchStrategy.nextMove = 1;
        }
        catch (ContradictionException e) {
            this.searchStrategy.nextMove = e.getContradictionMove();
        }
    }

    @Override
    public void restart() {
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.log(Level.CONFIG, "- Restarting search - {0} Restarts", this.getRestartCount());
        }
        this.kickRestart.restoreRootNode(this.ctx);
        try {
            this.searchStrategy.postDynamicCut();
            this.searchStrategy.solver.propagate();
            this.ctx = this.searchStrategy.getReusableInitialTrace();
            this.searchStrategy.nextMove = 0;
            if (this.searchStrategy.limitManager.newRestart()) {
                LOGGER.config("- Limit reached: stop restarting");
                this.setRestartAfterEachSolution(false);
                this.searchStrategy.limitManager.cancelRestartStrategy();
            }
        }
        catch (ContradictionException e) {
            this.stop = true;
        }
    }
}

