/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.disjunctive;

import choco.cp.solver.constraints.global.scheduling.disjunctive.IDisjRules;
import choco.cp.solver.constraints.global.scheduling.trees.IThetaLambdaTree;
import choco.cp.solver.constraints.global.scheduling.trees.IThetaOmegaTree;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.scheduling.IRTask;
import java.util.Arrays;

final class UpdateManager {
    public final IDisjRules rules;
    private final IRTask[] updateL;
    private int updateCount;
    private final IRTask[] removeL;
    private int removeCount;

    protected UpdateManager(IDisjRules rules, int capacity, boolean enableRemove) {
        this.rules = rules;
        this.removeL = enableRemove ? new IRTask[capacity] : null;
        this.updateL = new IRTask[capacity];
    }

    public void clear() {
        Arrays.fill(this.updateL, null);
        this.updateCount = 0;
        if (this.removeL != null) {
            Arrays.fill(this.removeL, null);
            this.removeCount = 0;
        }
    }

    public void storeUpdate(IRTask t, int value) {
        t.storeValue(value);
        this.updateL[this.updateCount++] = t;
    }

    public void storeRemoval(IRTask t) throws ContradictionException {
        t.remove();
        assert (t.isEliminated());
        this.removeL[this.removeCount++] = t;
    }

    public void storeLambdaRemoval(IThetaLambdaTree tree) throws ContradictionException {
        IRTask t = (IRTask)tree.getResponsibleTask();
        assert (t != null);
        this.storeRemoval(t);
        tree.removeFromLambda(t.getHTask());
    }

    public void storeLambdaRemoval(IRTask t, IThetaLambdaTree tree) throws ContradictionException {
        this.storeRemoval(t);
        tree.removeFromLambda(t.getHTask());
    }

    public void storeOmegaRemoval(IRTask t, IThetaOmegaTree tree) throws ContradictionException {
        this.storeRemoval(t);
        tree.removeFromOmega(t);
    }

    public final void fireRemovals() {
        if (this.removeCount > 0) {
            for (int i = 0; i < this.removeCount; ++i) {
                this.removeL[i].fireRemoval();
            }
            this.removeCount = 0;
            this.rules.fireDomainChanged();
        }
    }

    public boolean updateEST() throws ContradictionException {
        if (this.updateCount > 0) {
            boolean noFixPoint = false;
            for (int i = 0; i < this.updateCount; ++i) {
                if (this.updateL[i].isEliminated()) continue;
                noFixPoint |= this.updateL[i].updateEST();
            }
            this.updateCount = 0;
            if (noFixPoint) {
                this.rules.fireDomainChanged();
            }
            return noFixPoint;
        }
        return false;
    }

    public boolean fireAndUpdateEST() throws ContradictionException {
        this.fireRemovals();
        return this.updateEST();
    }

    public boolean updateLCT() throws ContradictionException {
        if (this.updateCount > 0) {
            boolean noFixPoint = false;
            for (int i = 0; i < this.updateCount; ++i) {
                if (this.updateL[i].isEliminated()) continue;
                noFixPoint |= this.updateL[i].updateLCT();
            }
            this.updateCount = 0;
            if (noFixPoint) {
                this.rules.fireDomainChanged();
            }
            return noFixPoint;
        }
        return false;
    }

    public boolean fireAndUpdateLCT() throws ContradictionException {
        this.fireRemovals();
        return this.updateLCT();
    }
}

