/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractTernIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.BitSet;

public final class Element2D
extends AbstractTernIntSConstraint {
    protected int[][] lvals;
    protected int dim1;
    protected int dim2;
    protected int cste;

    public Element2D(IntDomainVar v0, IntDomainVar v1, IntDomainVar v2, int[][] lvals) {
        super(v0, v1, v2);
        this.lvals = lvals;
        this.dim1 = lvals.length;
        this.dim2 = lvals[0].length;
        this.cste = 0;
        for (int i = 0; i < this.dim1; ++i) {
            for (int j = 0; j < this.dim2; ++j) {
                if (lvals[i][j] >= 0 || lvals[i][j] >= -this.cste) continue;
                this.cste = -lvals[i][j];
            }
        }
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == 0) {
            if (this.v0.hasEnumeratedDomain()) {
                return 12;
            }
            return 11;
        }
        if (idx == 1) {
            if (this.v1.hasEnumeratedDomain()) {
                return 12;
            }
            return 11;
        }
        if (this.v2.hasEnumeratedDomain()) {
            return 12;
        }
        return 11;
    }

    public void updateValueFromIndex() throws ContradictionException {
        int UB1;
        int minVal = Integer.MAX_VALUE;
        int maxVal = Integer.MIN_VALUE;
        int UB0 = this.v0.getSup();
        int i = this.v0.getInf();
        while (i <= UB0) {
            UB1 = this.v1.getSup();
            int j = this.v1.getInf();
            while (j <= UB1) {
                int val = this.lvals[i][j];
                if (minVal > val) {
                    minVal = val;
                }
                if (maxVal < val) {
                    maxVal = val;
                }
                j = this.v1.getNextDomainValue(j);
            }
            i = this.v0.getNextDomainValue(i);
        }
        this.v2.updateSup(maxVal, this, false);
        this.v2.updateInf(minVal, this, false);
        if (this.v2.hasEnumeratedDomain()) {
            BitSet feasValues = new BitSet(this.v2.getDomainSize());
            UB0 = this.v0.getSup();
            int i2 = this.v0.getInf();
            while (i2 <= UB0) {
                UB1 = this.v1.getSup();
                int j = this.v1.getInf();
                while (j <= UB1) {
                    feasValues.set(this.lvals[i2][j] + this.cste);
                    j = this.v1.getNextDomainValue(j);
                }
                i2 = this.v0.getNextDomainValue(i2);
            }
            int UB2 = this.v2.getSup();
            int i3 = this.v2.getInf();
            while (i3 <= UB2) {
                if (!feasValues.get(i3 + this.cste)) {
                    this.v2.removeVal(i3, this, false);
                }
                i3 = this.v2.getNextDomainValue(i3);
            }
        }
    }

    public boolean testValueVarV0(int idx) {
        boolean ret = false;
        int ub = this.v1.getSup();
        int val = this.v1.getInf();
        while (!ret && val <= ub) {
            ret = this.v2.canBeInstantiatedTo(this.lvals[idx][val]);
            val = this.v1.getNextDomainValue(val);
        }
        return ret;
    }

    public boolean testValueVarV1(int idx) {
        boolean ret = false;
        int ub = this.v0.getSup();
        int val = this.v0.getInf();
        while (!ret && val <= ub) {
            ret = this.v2.canBeInstantiatedTo(this.lvals[val][idx]);
            val = this.v0.getNextDomainValue(val);
        }
        return ret;
    }

    public void updateIndexFromValue() throws ContradictionException {
        int i;
        int minFeasibleIndex1 = this.v0.getInf();
        int minFeasibleIndex2 = this.v1.getInf();
        int maxFeasibleIndex1 = this.v0.getSup();
        int maxFeasibleIndex2 = this.v1.getSup();
        int thecause1 = -1;
        int thecause2 = -1;
        if (this.v2.hasEnumeratedDomain()) {
            thecause1 = this.getConstraintIdx(0);
        }
        if (this.v2.hasEnumeratedDomain()) {
            thecause2 = this.getConstraintIdx(1);
        }
        if (this.v0.hasEnumeratedDomain()) {
            IntDomain v0Dom = this.v0.getDomain();
            i = v0Dom.getNextValue(minFeasibleIndex1 - 1);
            while (i <= maxFeasibleIndex1) {
                if (!this.testValueVarV0(i)) {
                    this.v0.removeVal(i, this, false);
                }
                i = v0Dom.getNextValue(i);
            }
        } else {
            int UB0 = this.v0.getSup();
            int val = this.v0.getInf();
            while (val <= UB0 && !this.testValueVarV0(val)) {
                minFeasibleIndex1 = val;
                val = this.v0.getNextDomainValue(val);
            }
            this.v0.updateInf(minFeasibleIndex1, this, false);
            while (maxFeasibleIndex1 > 0 && this.v0.canBeInstantiatedTo(maxFeasibleIndex1) && !this.testValueVarV0(maxFeasibleIndex1)) {
                --maxFeasibleIndex1;
            }
            this.v0.updateSup(maxFeasibleIndex1, this, false);
        }
        if (this.v1.hasEnumeratedDomain()) {
            IntDomain v1Dom = this.v1.getDomain();
            i = v1Dom.getNextValue(minFeasibleIndex2 - 1);
            while (i <= maxFeasibleIndex2) {
                if (!this.testValueVarV1(i)) {
                    this.v1.removeVal(i, this, false);
                }
                i = v1Dom.getNextValue(i);
            }
        } else {
            int v1val;
            DisposableIntIterator v1It = this.v1.getDomain().getIterator();
            while (v1It.hasNext() && !this.testValueVarV1(v1val = v1It.next())) {
                minFeasibleIndex2 = v1val;
            }
            v1It.dispose();
            this.v1.updateInf(minFeasibleIndex2, this, false);
            while (maxFeasibleIndex2 > 0 && this.v1.canBeInstantiatedTo(maxFeasibleIndex2) && !this.testValueVarV1(maxFeasibleIndex2)) {
                --maxFeasibleIndex2;
            }
            this.v1.updateSup(maxFeasibleIndex2, this, false);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        this.v0.updateInf(0, this, false);
        this.v1.updateInf(0, this, false);
        this.v0.updateSup(this.dim1 - 1, this, false);
        this.v1.updateSup(this.dim2 - 1, this, false);
        this.updateIndexFromValue();
        this.updateValueFromIndex();
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx <= 1) {
            this.updateValueFromIndex();
        } else {
            this.updateIndexFromValue();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx <= 1) {
            this.updateValueFromIndex();
        } else {
            this.updateIndexFromValue();
        }
    }

    @Override
    public void awakeOnBounds(int idx) throws ContradictionException {
        if (idx <= 1) {
            this.updateValueFromIndex();
        } else {
            this.updateIndexFromValue();
        }
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        if (idx <= 1) {
            this.updateValueFromIndex();
        } else {
            this.updateIndexFromValue();
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx <= 1) {
            this.updateValueFromIndex();
        } else {
            this.updateIndexFromValue();
        }
    }

    @Override
    public Boolean isEntailed() {
        if (this.v2.isInstantiated()) {
            boolean b = true;
            int ub0 = this.v0.getSup();
            int v0val = this.v0.getInf();
            while (b && v0val <= ub0) {
                int ub1 = this.v1.getSup();
                int v1val = this.v1.getInf();
                while (b && v1val <= ub1) {
                    b &= this.lvals[v0val][v1val] == this.v2.getVal();
                    v1val = this.v1.getNextDomainValue(v1val);
                }
                v0val = this.v0.getNextDomainValue(v0val);
            }
            if (b) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return this.lvals[tuple[0]][tuple[1]] == tuple[2];
    }

    @Override
    public String pretty() {
        return this.v2.pretty() + " = nth(" + this.v0.pretty() + ", " + this.v1.pretty() + ", " + StringUtils.pretty(this.lvals) + ")";
    }
}

