% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_collate.R
\name{sim_collate}
\alias{sim_collate}
\title{Collate several subsets of a melted similarity matrix, required for computing
metrics.}
\usage{
sim_collate(
  sim_df,
  all_same_cols_rep,
  annotation_cols,
  any_different_cols_rep = NULL,
  all_different_cols_rep = NULL,
  all_same_cols_ref = NULL,
  all_same_cols_rep_ref = NULL,
  all_same_cols_non_rep = NULL,
  any_different_cols_non_rep = NULL,
  all_different_cols_non_rep = NULL,
  any_different_cols_group = NULL,
  all_same_cols_group = NULL,
  reference = NULL,
  drop_reference = FALSE,
  drop_group = NULL
)
}
\arguments{
\item{sim_df}{\code{metric_sim} object.}

\item{all_same_cols_rep}{optional character vector specifying columns.}

\item{annotation_cols}{character vector specifying which columns from
\code{metadata} to annotate the left index of the filtered \code{sim_df}
with.}

\item{any_different_cols_rep}{optional character vector specifying
columns.}

\item{all_different_cols_rep}{optional character vector specifying
columns.}

\item{all_same_cols_ref}{optional character vector specifying columns.}

\item{all_same_cols_rep_ref}{optional character vector specifying columns.}

\item{all_same_cols_non_rep}{optional character vector specifying columns.}

\item{any_different_cols_non_rep}{optional character vector specifying
columns.}

\item{all_different_cols_non_rep}{optional character vector specifying
columns.}

\item{any_different_cols_group}{optional character vector specifying columns.}

\item{all_same_cols_group}{optional character vector specifying columns.}

\item{reference}{optional character string specifying reference.}

\item{drop_reference}{optional boolean specifying whether to filter (drop)
pairs using \code{reference} on the left index.}

\item{drop_group}{optional tbl; rows that match on \code{drop_group} on the
left or right index are dropped.}
}
\value{
\code{metric_sim} object comprising a filtered \code{sim_df} with
sets of pairs, preserving the same \code{metric_sim} attributes as
\code{sim_df}.
}
\description{
\code{sim_collate} collates several subsets of a melted similarity matrix,
required for computing metrics.
}
\details{
\subsection{0. Filter out some rows}{

Filter out pairs that match \code{drop_group} in either right or left indices
}

\subsection{1. Similarity to reference}{

Fetch similarities between
\itemize{
\item (a) all rows (except, optionally those containing \code{reference}), and
\item (b) all rows containing \code{reference}
}

Do so only for those (a, b) pairs that
\itemize{
\item have \emph{same} values in \emph{all} columns of \code{all_same_cols_ref}
}
}

\subsection{2. Similarity to replicates (no references)}{

Fetch similarities between
\itemize{
\item (a) all rows except \code{reference} rows, and
\item (b) all rows except \code{reference} rows (i.e. to each other)
}

Do so for only those (a, b) pairs that
\itemize{
\item have \emph{same} values in \emph{all} columns of \code{all_same_cols_rep}
\item have \emph{different} values in \emph{all} columns of \code{all_different_cols_rep}
(if specified)
\item have \emph{different} values in \emph{at least one} column of
\code{any_different_cols_rep} (if specified)
}

Keep, both, (a, b) and (b, a)
}

\subsection{3. Similarity to replicates (only references)}{

Fetch similarities between
\itemize{
\item (a) all rows containing \code{reference}, and
\item (b) all rows containing \code{reference} (i.e. to each other)
}

Do so for only those (a, b) pairs that
\itemize{
\item have \emph{same} values in \emph{all} columns of \code{all_same_cols_rep_ref}.
}

Keep, both, (a, b) and (b, a)
}

\subsection{4. Similarity to non-replicates}{

Fetch similarities between
\itemize{
\item (a) all rows (except, optionally, \code{reference} rows), and
\item (b) all rows except \code{reference} rows
}

Do so for only those (a, b) pairs that
\itemize{
\item have \emph{same} values in \emph{all} columns of \code{all_same_cols_non_rep}
\item have \emph{different} values in \emph{all} columns \code{all_different_cols_non_rep}
\item have \emph{different} values in \emph{at least one} column of
\code{any_different_cols_non_rep}
}

Keep, both, (a, b) and (b, a)
}

\subsection{5. Similarity to group}{

Fetch similarities between
\itemize{
\item (a) all rows (except, optionally, \code{reference} rows), and
\item (b) all rows (except, optionally, \code{reference} rows)
}

Do so for only those (a, b) pairs that
\itemize{
\item have \emph{same} values in \emph{all} columns of \code{all_same_cols_group}
\item have \emph{different} values in \emph{at least one} column of
\code{any_different_cols_group}
}

Keep, both, (a, b) and (b, a)
}
}
\examples{

sim_df <- matric::sim_calculate(matric::cellhealth)

drop_group <-
  data.frame(Metadata_gene_name = "EMPTY")

reference <-
  data.frame(Metadata_gene_name = c("Chr2"))

all_same_cols_ref <-
  c(
    "Metadata_cell_line",
    "Metadata_Plate"
  )

all_same_cols_rep <-
  c(
    "Metadata_cell_line",
    "Metadata_gene_name",
    "Metadata_pert_name"
  )

all_same_cols_rep_ref <-
  c(
    "Metadata_cell_line",
    "Metadata_gene_name",
    "Metadata_pert_name",
    "Metadata_Plate"
  )

any_different_cols_non_rep <-
  c(
    "Metadata_cell_line",
    "Metadata_gene_name",
    "Metadata_pert_name"
  )

all_same_cols_non_rep <-
  c(
    "Metadata_cell_line",
    "Metadata_Plate"
  )

all_different_cols_non_rep <-
  c("Metadata_gene_name")

all_same_cols_group <-
  c(
    "Metadata_cell_line",
    "Metadata_gene_name"
  )

any_different_cols_group <-
  c(
    "Metadata_cell_line",
    "Metadata_gene_name",
    "Metadata_pert_name"
  )

annotation_cols <-
  c(
    "Metadata_cell_line",
    "Metadata_gene_name",
    "Metadata_pert_name"
  )

collated_sim <-
  matric::sim_collate(
    sim_df,
    reference = reference,
    all_same_cols_rep = all_same_cols_rep,
    all_same_cols_rep_ref = all_same_cols_rep_ref,
    all_same_cols_ref = all_same_cols_ref,
    any_different_cols_non_rep = any_different_cols_non_rep,
    all_same_cols_non_rep = all_same_cols_non_rep,
    all_different_cols_non_rep = all_different_cols_non_rep,
    any_different_cols_group = any_different_cols_group,
    all_same_cols_group = all_same_cols_group,
    annotation_cols = annotation_cols,
    drop_group = drop_group
  )

head(collated_sim)

collated_sim \%>\%
  dplyr::group_by(type) \%>\%
  dplyr::tally()
}
