% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notation.R
\name{row-col-notation}
\alias{row-col-notation}
\alias{notation_vec}
\alias{arrow_notation}
\alias{paren_notation}
\alias{bracket_notation}
\alias{split_pref_suff}
\alias{paste_pref_suff}
\alias{flip_pref_suff}
\alias{switch_notation}
\alias{switch_notation_byname}
\title{Row and column notation}
\usage{
notation_vec(
  sep = " -> ",
  pref_start = "",
  pref_end = "",
  suff_start = "",
  suff_end = ""
)

arrow_notation()

paren_notation(suff_start = " (", suff_end = ")")

bracket_notation(suff_start = " [", suff_end = "]")

split_pref_suff(x, notation = arrow_notation())

paste_pref_suff(
  ps = list(pref = pref, suff = suff),
  pref = NULL,
  suff = NULL,
  notation = arrow_notation()
)

flip_pref_suff(x, notation = arrow_notation())

switch_notation(x, from, to, flip = FALSE)

switch_notation_byname(a, margin = c(1, 2), from, to, flip = FALSE)
}
\arguments{
\item{sep}{a string separator between prefix and suffix. Default is " -> ".}

\item{pref_start}{a string indicating the start of a prefix. Default is \code{NULL}.}

\item{pref_end}{a string indicating the end of a prefix. Default is the value of \code{sep}.}

\item{suff_start}{a string indicating the start of a suffix. Default is the value of \code{sep}.}

\item{suff_end}{a string indicating the end of a suffix. Default is \code{NULL}.}

\item{x}{a string or list of strings to be operated upon.}

\item{notation}{a notation vector generated by one of the \verb{*_notation()} functions, such as
\code{notation_vec()}, \code{arrow_notation()}, or \code{bracket_notation()}.
Default is \code{arrow_notation()}.}

\item{ps}{a list of prefixes and suffixes in which each item of the list is itself a list with two items named \code{pref} and \code{suff}.}

\item{pref}{a string or list of strings that are prefixes. Default is \code{NULL}.}

\item{suff}{a string of list of strings that are suffixes. Default is \code{NULL}.}

\item{from}{the \code{notation} to switch \emph{away from}.}

\item{to}{the \code{notation} to switch \emph{to}.}

\item{flip}{a boolean that tells whether to also flip the notation. Default is \code{FALSE}.}

\item{a}{a matrix or list of matrices whose row and/or column notation is to be changed.}

\item{margin}{\code{1} for rows, \code{2} for columns, or \code{c(1, 2)} for both rows and columns. Default is \code{c(1, 2)}.}
}
\value{
for \code{notation_vec()}, \code{arrow_notation()}, and \code{bracket_notation()},
a string vector with named items \code{pref_start}, \code{pref_end}, \code{suff_start}, and \code{suff_end};
for \code{split_pref_suff()}, a string list with named items \code{pref} and \code{suff};
for \code{paste_pref_suff()}, \code{slip_pref_suff()}, and \code{switch_notation()},
a string list in notation format specified by various \code{notation} arguments, including
\code{from}, and \code{to},
for \code{switch_row_col_notation_byname()}, matrices with row and column names with switched notation,
per arguments.
}
\description{
It is often convenient to represent row and column names
with notation that includes a prefix and a suffix,
with corresponding separators or start-end string sequences.
There are several functions that call \code{notation_vec()} to generate specialized versions
or otherwise manipulate row and column names on their own or as row or column names.
\itemize{
\item \code{notation_vec()} builds a vector of notation symbols in a standard format
that is used by \code{matsbyname} in several places.
By default, it builds a list of notation symbols that provides an arrow
separator (" -> ") between prefix and suffix.
\item \code{arrow_notation()} builds a list of notation symbols that provides an arrow separator (" -> ")
between prefix and suffix.
\item \code{paren_notation()} builds a list of notation symbols that provides parentheses around the suffix ("prefix (suffix)").
\item \code{bracket_notation()} builds a list of notation symbols that provides square brackets around the suffix ("prefix [suffix]").
\item \code{split_pref_suff()} splits prefixes from suffixes, returning each in a list with names \code{pref} and \code{suff}.
If no delimiters are found, \code{x} is returned in the \code{pref} item, unmodified.
\item \verb{paste_pref_suff(()} paste0's prefixes and suffixes, the inverse of \code{split_pref_suff()}.
\item \code{flip_pref_suff()} switches the location of prefix and suffix, such that the prefix becomes the suffix, and
the suffix becomes the prefix.
E.g., "a -> b" becomes "b -> a" or "a [b]" becomes "b [a]".
\item \code{switch_notation()} switches from one type of notation to another based on the \code{from} and \code{to} arguments.
Optionally, prefix and suffix can be \code{flip}ped.
\item \code{switch_notation_byname()} switches matrix row and/or column names from one type of notation to another
based on the \code{from} and \code{to} arguments.
Optionally, prefix and suffix can be \code{flip}ped.
}

If \code{sep} only is specified (default is " -> "),
\code{pref_start}, \code{pref_end}, \code{suff_start}, and \code{suff_end} are
set appropriately.

None of the strings in a notation vector are considered part of the prefix or suffix.
E.g., "a -> b" in arrow notation means that "a" is the prefix and "b" is the suffix.
}
\examples{
notation_vec()
arrow_notation()
bracket_notation()
split_pref_suff("a -> b", notation = arrow_notation())
flip_pref_suff("a [b]", notation = bracket_notation())
switch_notation("a -> b", from = arrow_notation(), to = bracket_notation())
switch_notation("a -> b", from = arrow_notation(), to = bracket_notation(), 
                flip = TRUE)
m <- matrix(c(1, 2, 
              3, 4), nrow = 2, ncol = 2, byrow = TRUE, 
            dimnames = list(c("b [a]", "d [c]"), c("f [e]", "h [g]"))) \%>\% 
  setrowtype("Products [Industries]") \%>\% setcoltype("Industries [Products]")
m
switch_notation_byname(m, from = bracket_notation(), to = arrow_notation(), 
                       flip = TRUE)
# Also works for lists.
# Note that margin must be specified as a list here.
switch_notation_byname(list(m, m), margin = list(c(1, 2)), 
                       from = bracket_notation(), 
                       to = arrow_notation(), flip = TRUE)
}
