% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{matricize_byname}
\alias{matricize_byname}
\title{Matricize a vector}
\usage{
matricize_byname(a, notation)
}
\arguments{
\item{a}{a row (column) vector to be converted to a matrix based on its row (column) names.}

\item{notation}{a string vector created by \code{notation_vec()} that identifies the notation for row or column names.}
}
\value{
a matrix created from vector \code{a}.
}
\description{
Converts a vector with rows or columns named according to \code{notation}
into a matrix.
}
\examples{
v <- matrix(c(1,
              2,
              3, 
              4), 
            nrow = 4, ncol = 1, dimnames = list(c("p1 -> i1", 
                                                  "p2 -> i1", 
                                                  "p1 -> i2", 
                                                  "p2 -> i2"))) \%>\% 
  setrowtype("Products -> Industries")
# Default separator is " -> ".
matricize_byname(v, notation = arrow_notation())
}
