% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_beast2_ns_pkg_installed.R
\name{is_beast2_ns_pkg_installed}
\alias{is_beast2_ns_pkg_installed}
\title{Is the BEAST2 NS package installed?}
\usage{
is_beast2_ns_pkg_installed(
  show_warnings = FALSE,
  verbose = FALSE,
  beast2_folder = beastier::get_default_beast2_folder()
)
}
\arguments{
\item{show_warnings}{set to TRUE to show warnings}

\item{verbose}{set to TRUE for extra output, as can be used in debugging}

\item{beast2_folder}{the folder where the BEAST2 is installed.
Note that this is not the folder where the BEAST2 executable is installed:
the BEAST2 executable is in a subfolder.
Use \link[beastier]{get_default_beast2_folder}
  to get the default BEAST2 folder.
Use \link[beastier]{get_default_beast2_bin_path}
  to get the full path to the default BEAST2 executable.
Use \link[beastier]{get_default_beast2_jar_path}
  to get the full path to the default BEAST2 jar file.}
}
\value{
TRUE if the BEAST2 NS package is installed, FALSE otherwise
}
\description{
Determine if the BEAST2 NS package is installed.
}
\details{
Unlike \link{is_beast2_pkg_installed},
this function does not need an internet connection.
Instead, the function calls BEAST2 to read a BEAST2 XML file that
uses NS.
}
\examples{
\dontrun{
  is_beast2_ns_pkg_installed()
}
}
\author{
Richèl J.C. Bilderbeek
}
