% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexagon_maze.r
\name{hexagon_maze}
\alias{hexagon_maze}
\title{hexagon_maze .}
\usage{
hexagon_maze(depth, unit_len, clockwise = TRUE, method = c("two_trapezoids",
  "six_triangles", "three_parallelograms", "random"),
  start_from = c("midpoint", "corner"), draw_boundary = FALSE,
  num_boundary_holes = 2, boundary_lines = TRUE, boundary_holes = NULL,
  boundary_hole_color = NULL, end_side = 1)
}
\arguments{
\item{depth}{the depth of recursion. This controls the
side length. If an integer then nice recursive mazes
are possible, but non-integral values corresponding to
log base 2 of integers are also acceptable.}

\item{unit_len}{the unit length in graph coordinates. This controls
the width of the \sQuote{holes} in the boundary lines and
generally controls the spacing of mazes.}

\item{clockwise}{whether to draw clockwise.}

\item{method}{there are many ways to recursive draw an isosceles
trapezoid.  The following values are acceptable:
\describe{
\item{two_trapezoids}{Two isosceles trapezoids are placed next to each
other, with a holey line between them.}
\item{size_triangles}{Six equilateral triangles are packed together, with
five holey lines and one solid line.}
\item{three_parallelograms}{Three parallelograms are packed together,
with two holey lines and one solid line between them.}
\item{random}{A method is chosen uniformly at random.}
}}

\item{start_from}{whether to start from the midpoint of the first side
of a maze, or from the corner facing the first side.}

\item{draw_boundary}{a boolean indicating whether a final boundary shall be
drawn around the maze.}

\item{num_boundary_holes}{the number of boundary sides which should be
randomly selected to have holes. Note that the \code{boundary_holes}
parameter takes precedence.}

\item{boundary_lines}{indicates which of the sides of the maze
shall have drawn boundary lines. Can be a logical array indicating
which sides shall have lines, or a numeric array, giving the
index of sides that shall have lines.}

\item{boundary_holes}{an array indicating which of the boundary lines
have holes. If \code{NULL}, then boundary holes are randomly selected
by the \code{num_boundary_holes} parameter. If numeric, indicates
which sides of the maze shall have holes. If a boolean array, indicates
which of the sides shall have holes. These forms are recycled
if needed. See \code{\link{holey_path}}. Note that if no line
is drawn, no hole can be drawn either.}

\item{boundary_hole_color}{the color of boundary holes. A value of
\code{NULL} indicates no colored holes. See \code{\link{holey_path}}
for more details. Can be an array of colors, or colors and the 
value \code{'clear'}, which stands in for \code{NULL} to
indicate no filled hole to be drawn.}

\item{end_side}{the number of the side to end on. A value of
1 corresponds to the starting side, while higher numbers
correspond to the drawn side of the figure in the canonical order
(that is, the order induced by the \code{clockwise} parameter).}
}
\value{
nothing; the function is called for side effects only, though in
the future this might return information about the drawn boundary of
the shape.
}
\description{
Recursively draw a regular hexagon, with sides consisting
of \eqn{2^{depth}} pieces of length \code{unit_len}.
}
\details{
Draws a maze in a regular hexagon, starting from the midpoint
of the first side (or the corner before the first side via the
\code{start_from} option). A number of different recursive methods
are supported, dividing the triangle into trapezoids, triangles
or parallelograms. Optionally draws boundaries
around the hexagon, with control over which sides have lines and
holes. Sides of the hexagon consist of \eqn{2^{depth}} segments
of length \code{unit_len}, though \code{depth} may be non-integral.
A number of different methods are supported.

For \code{method='two_trapezoids'}:

\if{html}{
\figure{hex-trapezoids-1.png}{options: width="100\%" alt="Figure: two trapezoids"}
}
\if{latex}{
\figure{hex-trapezoids-1.png}{options: width=7cm}
}

For \code{method='six_trapezoids'}:

\if{html}{
\figure{hex-triangles-1.png}{options: width="100\%" alt="Figure: six triangles"}
}
\if{latex}{
\figure{hex-triangles-1.png}{options: width=7cm}
}

For \code{method='three_trapezoids'}:

\if{html}{
\figure{hex-parallelo-1.png}{options: width="100\%" alt="Figure: three parallelograms"}
}
\if{latex}{
\figure{hex-parallelo-1.png}{options: width=7cm}
}
}
\examples{
library(TurtleGraphics)
turtle_init(2000,2000)
turtle_hide()
turtle_do({
	turtle_up()
	turtle_backward(250)
	turtle_right(90)
	turtle_forward(150)
	turtle_left(90)

	turtle_right(60)
	hexagon_maze(depth=3,12,clockwise=FALSE,method='six_triangles',
	  draw_boundary=TRUE,boundary_holes=c(1,4),boundary_hole_color='green')
})


turtle_init(2000,2000)
turtle_hide()
turtle_do({
	turtle_up()
	turtle_backward(250)
	turtle_right(90)
	turtle_forward(150)
	turtle_left(90)

	turtle_right(60)
	hexagon_maze(depth=log2(20),12,clockwise=FALSE,method='six_triangles',
	  draw_boundary=TRUE,boundary_holes=c(1,4),boundary_hole_color='green')
})


turtle_init(1000,1000)
turtle_hide()
turtle_do({
	turtle_up()
	turtle_backward(250)
	turtle_right(90)
	turtle_forward(150)
	turtle_left(90)

	turtle_right(60)
	hexagon_maze(depth=3,12,clockwise=FALSE,method='three_parallelograms',
	  draw_boundary=TRUE,boundary_holes=c(1,4),boundary_hole_color='green')
})

turtle_init(1000,1000)
turtle_hide()
turtle_do({
	hexagon_maze(depth=3,15,clockwise=TRUE,method='two_trapezoids',
	  draw_boundary=TRUE,boundary_holes=c(1,4))
	hexagon_maze(depth=3,15,clockwise=FALSE,method='two_trapezoids',
	  draw_boundary=TRUE,boundary_lines=c(2,3,4,5,6),boundary_holes=c(1,4))
})

turtle_init(1000,1000)
turtle_hide()
turtle_do({
	depth <- 3
	num_segs <- 2^depth
	unit_len <- 8
	multiplier <- -1
	hexagon_maze(depth=depth,unit_len,clockwise=FALSE,method='two_trapezoids',
	  draw_boundary=FALSE)
	for (iii in c(1:6)) {
		if (iii \%in\% c(1,4)) {
			holes <- c(1,4) 
		} else {
			holes <- c(1)
		}
		hexagon_maze(depth=depth,unit_len,clockwise=TRUE,method='two_trapezoids',
		  draw_boundary=TRUE,boundary_holes=holes)
		turtle_forward(distance=unit_len * num_segs/2)
		turtle_right(multiplier * 60)
		turtle_forward(distance=unit_len * num_segs/2)
	}
})
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{plotting}
