% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliff.R
\name{cliff}
\alias{cliff}
\title{Compute Effect Size}
\usage{
cliff(v1, v0)
}
\arguments{
\item{v1}{a vector, biomarker values from the treatment group.}

\item{v0}{a vector, biomarker values from the control group.}
}
\value{
\code{cliff} returns a numeric that is the Cliff's delta of the
  treatment group.
}
\description{
\code{cliff} calculates Cliff's delta statistic using the rank sum method.
}
\examples{
cliff(unlist(sokolova2021[7:12, 2]), unlist(sokolova2021[1:6, 2]))

}
\references{
Cliff, N. (1993). Dominance statistics: Ordinal analyses to
  answer ordinal questions. Psychological Bulletin, 114(3), 494–509.
  \doi{10.1037/0033-2909.114.3.494}. \cr \cr Vargha, A., &
  Delaney, H. D. (2000). A Critique and Improvement of the CL Common Language
  Effect Size Statistics of McGraw and Wong. Journal of Educational and
  Behavioral Statistics, 25(2), 101–132.
  \doi{10.3102/10769986025002101}. \cr \cr Ruscio, J., &
  Mullen, T. (2012). Confidence Intervals for the Probability of Superiority
  Effect Size Measure and the Area Under a Receiver Operating Characteristic
  Curve. Multivariate Behavioral Research, 47(2), 201–223.
  \doi{10.1080/00273171.2012.658329}.
}
\seealso{
\code{\link[RProbSup]{CalcA1}}.
}
