% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_test.R
\name{corr_test}
\alias{corr_test}
\title{Correlation Coefficient Test}
\usage{
corr_test(x, y, conf.int)
}
\arguments{
\item{x, y}{numeric vectors of data values}

\item{conf.int}{(optional) confidence level of the interval. Defaults to \code{0.90}}
}
\value{
Associated effect size measure, \emph{r}, and respective confidence intervals.
}
\description{
Provides magnitude-based inferences for the association between given data vectors. Evaluates normality assumption, performs either Pearson or Spearman correlation and subsequently estimates magnitude-based inferences.
}
\details{
Refer to vignette for further information.
}
\examples{
a <- rnorm(25, 80, 35)
b <- rnorm(25, 100, 35)

corr_test(a, b, 0.95)
}
