% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d.e.mcmc.R
\name{d.e.mcmc}
\alias{d.e.mcmc}
\title{MCMC Ensemble sampler with the differential evolution jump move}
\usage{
d.e.mcmc(f, lower.inits, upper.inits, max.iter, n.walkers, ...)
}
\arguments{
\item{f}{function that returns a single scalar value proportional to the log
probability density to sample from.}

\item{lower.inits}{vector specifying for each parameter the lower value the
initial distribution.}

\item{upper.inits}{vector specifying for each parameter the upper value the
initial distribution.}

\item{max.iter}{maximum number of function evaluations}

\item{n.walkers}{number of walkers (ensemble size)}

\item{...}{further arguments passed to \code{f}}
}
\value{
List containing:
\itemize{
\item \code{samples[n.walkers,chain.length,n.dim]}
\item \code{log.p[n.walkers,chain.length]}
}
}
\description{
Markov Chain Monte Carlo sampler: using the differential evolution jump move
(implementation of the ter Braak differential evolution)
}
\references{
ter Braak, C. J. F. and Vrugt, J. A. (2008) Differential Evolution Markov
Chain with snooker updater and fewer chains. Statistics and Computing,
18(4), 435–446, \doi{10.1007/s11222-008-9104-9}
}
\author{
Sanda Dejanic
}
