% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_gen.R
\name{gen}
\alias{gen}
\title{Create a model component object for a generic random effects component in the linear predictor}
\usage{
gen(
  formula = ~1,
  factor = NULL,
  remove.redundant = FALSE,
  drop.empty.levels = FALSE,
  X = NULL,
  var = NULL,
  prior = NULL,
  Q0 = NULL,
  PX = NULL,
  GMRFmats = NULL,
  priorA = NULL,
  Leroux = FALSE,
  R0 = NULL,
  RA = NULL,
  constr = NULL,
  S0 = NULL,
  SA = NULL,
  formula.gl = NULL,
  name = "",
  sparse = NULL,
  debug = FALSE
)
}
\arguments{
\item{formula}{a model formula specifying the effects that vary over the levels of
the factor variable(s) specified by argument \code{factor}. Defaults to \code{~1},
corresponding to random intercepts. If \code{X} is specified \code{formula} is ignored.
Variable names are looked up in the data frame passed as \code{data} argument to
\code{\link{create_sampler}} or \code{\link{generate_data}}, or in \code{environment(formula)}.}

\item{factor}{a formula with factors by which the effects specified in the \code{formula}
argument vary. Often only one such factor is needed but multiple factors are allowed so that
interaction terms can be modeled conveniently. The formula must take the form
\code{ ~ f1(fac1, ...) * f2(fac2, ...) ...}, where
\code{fac1, fac2} are factor variables and \code{f1, f2} determine the
correlation structure assumed between levels of each factor, and the \code{...} indicate
that for some correlation types further arguments can be passed. Correlation structures
currently supported include \code{iid} for independent identically distributed effects,
\code{RW1} and \code{RW2} for random walks of first or second order over the factor levels,
\code{AR1} for first-order autoregressive effects, \code{season} for seasonal effects,
\code{spatial} for spatial (CAR) effects and \code{custom} for supplying a custom
precision matrix corresponding to the levels of the factor. For further details about
the correlation structures, and further arguments that can be passed, see
\code{\link{correlation}}. Argument \code{factor} is ignored if \code{X} is specified.
The factor variables are looked up in the data frame passed as \code{data} argument to
\code{\link{create_sampler}} or \code{\link{generate_data}}, or in \code{environment(formula)}.}

\item{remove.redundant}{whether redundant columns should be removed from the model matrix
associated with \code{formula}. Default is \code{FALSE}.}

\item{drop.empty.levels}{whether to remove factor levels without observations.}

\item{X}{A (possibly sparse) design matrix. This can be used instead of \code{formula} and \code{factor}.}

\item{var}{the (co)variance structure among the varying effects defined by \code{formula}
over the levels of the factors defined by \code{factor}.
The default is \code{"unstructured"}, meaning that a full covariance matrix
parameterization is used. For uncorrelated effects with unequal variances use
\code{var="diagonal"}. For uncorrelated effects with equal variances use \code{var="scalar"}.
In the case of a single varying effect there is no difference between these choices.}

\item{prior}{the prior specification for the variance parameters of the random effects.
These can currently be specified by a call to \code{\link{pr_invwishart}} in case
\code{var="unstructured"} or by a call to \code{\link{pr_invchisq}} otherwise.
See the documentation of those prior specification functions for more details.}

\item{Q0}{precision matrix associated with \code{formula}. This can only be used in
combination with \code{var="scalar"}.}

\item{PX}{whether parameter expansion should be used. Default is \code{TRUE}, which
applies parameter expansion with default options. The only exception is that for
gamma sampling distributions the default is \code{FALSE}, i.e. no parameter expansion.
Alternative options can be specified
by supplying a list with one or more of the following components:
\describe{
  \item{prior}{prior for the multiplicative expansion parameter. Defaults to a
    normal prior with mean 0 and standard deviation 1, unless the sampling
    distribution is gamma in which case the default is a Multivariate Log
    inverse Gamma prior. The default parameters can be changed using functions
    \code{\link{pr_normal}} or \code{\link{pr_MLiG}}.}
  \item{vector}{whether a redundant multiplicative expansion parameter is used for each varying effect
    specified by \code{formula}. The default is \code{TRUE} except when \code{var="scalar"}.
    If \code{FALSE} a single redundant multiplicative parameter is used.}
  \item{data.scale}{whether the data level scale is used as a variance factor for the expansion
    parameters. Default is \code{TRUE}.}
}}

\item{GMRFmats}{list of incidence/precision/constraint matrices. This can be specified
as an alternative to \code{factor}. It should be a list such as that returned
by \code{\link{compute_GMRF_matrices}}. Can be used together with argument \code{X}
as a flexible alternative to \code{formula} and \code{factor}.}

\item{priorA}{prior distribution for scale factors at the variance scale associated with \code{QA}.
In case of IGMRF models the scale factors correspond to the innovations.
The default \code{NULL} means not to use any local scale factors.
A prior can currently be specified using \code{\link{pr_invchisq}} or \code{\link{pr_exp}}.}

\item{Leroux}{this option alters the precision matrix determined by \code{factor} by taking a
weighted average of it with the identity matrix. If \code{TRUE} the model gains an additional parameter,
the 'Leroux' parameter, being the weight of the original, structured, precision matrix in the weighted
average. By default a uniform prior for the weight and a uniform Metropolis-Hastings proposal density
are employed. This default can be changed by supplying a list with elements a, b, and a.star, b.star,
implying a beta(a, b) prior and a beta(a.star, b.star) independence proposal density. A third option is
to supply a single number between 0 and 1, which is then used as a fixed value for the Leroux parameter.}

\item{R0}{an optional equality restriction matrix acting on the coefficients defined by \code{formula}, for each
level defined by \code{factor}. If c is the number of restrictions, \code{R0} is a
q0 x c matrix where q0 is the number of columns of the design matrix derived
from \code{formula}. Together with \code{RA} it defines the set of equality constraints
to be imposed on the vector of coefficients. Only allowed in combination with \code{var="scalar"}.}

\item{RA}{an optional equality restriction matrix acting on the coefficients defined by \code{factor},
for each effect defined by \code{formula}. If c is the number of restrictions, \code{RA} is a
l x c matrix where l is the number of levels defined by \code{factor}.
Together with \code{R0} this defines the set of equality constraints to be imposed on the vector
of coefficients.
If \code{constr=TRUE}, additional constraints are imposed, corresponding to the
null-vectors of the singular precision matrix in case of an intrinsic Gaussian Markov Random Field.}

\item{constr}{whether constraints corresponding to the null-vectors of the precision matrix
are to be imposed on the vector of coefficients. By default this is \code{TRUE} for
improper or intrinsic GMRF model components, i.e. components with a singular precision matrix
such as random walks or CAR spatial components.}

\item{S0}{an optional inequality restriction matrix acting on the coefficients defined by \code{formula}, for each
level defined by \code{factor}. If c is the number of restrictions, \code{S0} is a
q0 x c matrix where q0 is the number of columns of the design matrix derived
from \code{formula}. Together with \code{SA} it defines the set of inequality constraints
to be imposed on the vector of coefficients.}

\item{SA}{an optional inequality restriction matrix acting on the coefficients defined by \code{factor},
for each effect defined by \code{formula}. If c is the number of restrictions, \code{SA} is a
l x c matrix where l is the number of levels defined by \code{factor}.
Together with \code{S0} this defines the set of constraints to be imposed on the vector
of coefficients.}

\item{formula.gl}{a formula of the form \code{~ glreg(...)} for group-level predictors
around which the random effect component is hierarchically centered.
See \code{\link{glreg}} for details.}

\item{name}{the name of the model component. This name is used in the output of the MCMC simulation
function \code{\link{MCMCsim}}. By default the name will be 'gen' with the number of the model term attached.}

\item{sparse}{whether the model matrix associated with \code{formula} should be sparse.
The default is based on a simple heuristic based on storage size.}

\item{debug}{if \code{TRUE} a breakpoint is set at the beginning of the posterior
draw function associated with this model component. Mainly intended for developers.}
}
\value{
An object with precomputed quantities and functions for sampling from
 prior or conditional posterior distributions for this model component. Intended
 for internal use by other package functions.
}
\description{
This function is intended to be used on the right hand side of the \code{formula} argument to
\code{\link{create_sampler}} or \code{\link{generate_data}}.
}
\references{
J. Besag and C. Kooperberg (1995).
   On Conditional and Intrinsic Autoregression.
   Biometrika 82(4), 733-746.

 C.M. Carvalho, N.G. Polson and J.G. Scott (2010).
   The horseshoe estimator for sparse signals.
   Biometrika 97(2), 465-480.

 L. Fahrmeir, T. Kneib and S. Lang (2004).
   Penalized Structured Additive Regression for Space-Time Data:
   a Bayesian Perspective.
   Statistica Sinica 14, 731-761.

 A. Gelman (2006).
   Prior distributions for variance parameters in hierarchical models.
   Bayesian Analysis 1(3), 515-533.

 A. Gelman, D.A. Van Dyk, Z. Huang and W.J. Boscardin (2008).
   Using Redundant Parameterizations to Fit Hierarchical Models.
   Journal of Computational and Graphical Statistics 17(1), 95-122.

 B. Leroux, X. Lei and N. Breslow (1999).
   Estimation of Disease Rates in Small Areas: A New Mixed Model for Spatial Dependence.
   In M. Halloran and D. Berry (Eds.), Statistical Models in Epidemiology,
   the Environment and Clinical Trials, 135-178.

 T. Park and G. Casella (2008).
   The Bayesian Lasso.
   Journal of the American Statistical Association 103(482), 681-686.

 H. Rue and L. Held (2005).
   Gaussian Markov Random Fields.
   Chapman & Hall/CRC.
}
