% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCsim.R
\name{summary.mcdraws}
\alias{summary.mcdraws}
\title{Summarise an mcdraws object}
\usage{
\method{summary}{mcdraws}(
  object,
  vnames = NULL,
  probs = c(0.05, 0.5, 0.95),
  na.rm = FALSE,
  efficiency = FALSE,
  abbr = FALSE,
  batch.size = 100L,
  ...
)
}
\arguments{
\item{object}{an object of class \code{mcdraws}, typically generated by function \code{\link{MCMCsim}}.}

\item{vnames}{optional character vector to select a subset of parameters.}

\item{probs}{vector of probabilities at which to evaluate quantiles.}

\item{na.rm}{whether to remove NA/NaN draws in computing the summaries.}

\item{efficiency}{if \code{TRUE} the effective sample size per second of computation time is returned as well.}

\item{abbr}{if \code{TRUE} abbreviate the labels in the output.}

\item{batch.size}{number of parameter columns to process simultaneously for vector parameters. A larger batch size
may speed things up a little, but if an out of memory error occurs it may be a good idea to use a smaller number
and try again. The default is 100.}

\item{...}{arguments passed to \code{\link{n_eff}}.}
}
\value{
A list of class \code{mcdraws_summary} summarizing \code{object}.
}
\description{
Summarise an mcdraws object
}
\examples{
\donttest{
ex <- mcmcsae_example()
sampler <- create_sampler(ex$model, data=ex$dat)
sim <- MCMCsim(sampler, store.all=TRUE)
summary(sim)
par_names(sim)
summary(sim, c("beta", "v_sigma", "u_sigma"))
}

}
