% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcpfit_methods.R
\encoding{UTF-8}
\name{residuals.mcpfit}
\alias{residuals.mcpfit}
\alias{residuals}
\alias{resid}
\alias{resid.mcpfit}
\title{Compute Residuals From Mcpfit Objects}
\usage{
\method{residuals}{mcpfit}(
  object,
  newdata = NULL,
  summary = TRUE,
  probs = TRUE,
  prior = FALSE,
  varying = TRUE,
  arma = TRUE,
  nsamples = NULL,
  ...
)
}
\arguments{
\item{object}{An \code{mcpfit} object.}

\item{newdata}{A \code{tibble} or a \code{data.frame} containing predictors in the model. If \code{NULL} (default),
the original data is used.}

\item{summary}{Summarise at each x-value}

\item{probs}{Vector of quantiles. Only in effect when \code{summary == TRUE}.}

\item{prior}{TRUE/FALSE. Plot using prior samples? Useful for \code{mcp(..., sample = "both")}}

\item{varying}{\itemize{
\item \strong{TRUE:} All varying effects (\code{fit$pars$varying}).
\itemize{
\item \strong{FALSE:} No varying efects (\code{c()}).
\item \strong{Character vector:} Only include specified varying parameters - see \code{fit$pars$varying}.
}
}}

\item{arma}{Whether to include autoregressive effects.
\itemize{
\item \verb{TRUE:} Compute autoregressive residuals. Requires the response variable in \code{newdata}.
\item \verb{FALSE:} Disregard the autoregressive effects. For \code{family = gaussian()}, \code{predict()} just use \code{sigma} for residuals.
}}

\item{nsamples}{Integer or \code{NULL}. Number of samples to return/summarise.
If there are varying effects, this is the number of samples from each varying group.
\code{NULL} means "all". Ignored if both are \code{FALSE}. More samples trade speed for accuracy.}

\item{...}{Currently unused}
}
\description{
Equivalent to  \code{fitted(fit, ...) - fit$data[, fit$data$yvar]} (or \code{fitted(fit, ...) - newdata[, fit$data$yvar]}),
but with fixed arguments for \code{fitted}: \verb{rate = FALSE, which_y = 'ct', samples_format = 'tidy'}.
}
\examples{
\donttest{
residuals(ex_fit)
residuals(ex_fit, probs = c(0.1, 0.5, 0.9))  # With median and 80\% credible interval.
residuals(ex_fit, summary = FALSE)  # Samples instead of summary.
}

}
\seealso{
\code{\link{pp_eval}} \code{\link{fitted.mcpfit}} \code{\link{predict.mcpfit}}
}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
