% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier.R
\name{ESD_test}
\alias{ESD_test}
\title{EDS Test for Outliers}
\usage{
ESD_test(x, alpha = 0.05, h = 5)
}
\arguments{
\item{x}{(\code{numeric})\cr vector of observations that can be the difference from
Bland-Altman analysis. Normally the relative difference is preferred in IVD trials.
Missing(NA) is allowed but will be removed. There must be at least 10 available
observations in \code{x}.}

\item{alpha}{(\code{numeric})\cr type-I-risk, \eqn{\alpha}.}

\item{h}{(\code{integer})\cr the positive integer indicating the number of suspected
outliers. The argument \code{h} must be between 1 and \code{n-2} where n denotes the number of
available values in \code{x}. The default value is \code{h = 5}.}
}
\value{
A list class containing the results of the ESD test.
\itemize{
\item \code{stat} a data frame contains the several statistics about ESD test that includes
the index(\code{i}), Mean, SD, raw data(\code{x}), the location(\code{Obs}) in \code{x}, ESD statistics(ESDi),
Lambda and Outliers(\code{TRUE} or \code{FALSE}).
\item \code{ord} a vector with the order index of outliers that is equal to \code{Obs} in
the \code{stat} data frame.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Perform Rosner's generalized extreme Studentized deviate (ESD) test, which assumes
that the distribution is normal (Gaussian), can be used when the number of outliers
is unknown, and becomes more robust as the number of samples increases.
}
\note{
The algorithm for determining the number of outliers is as follows:
\itemize{
\item Compare ESDi with Lambda. If ESDi > Lambda then the observations will be
regards as outliers.
\item The order index corresponds to the available \code{x} data that has been removed the
missing (NA) value.
\item As we should compare if the ESD(h) and ESD(h+1) are equal, the h+1 ESD values
will be shown. If they are identical, both of them can not be regarded as outliers.
}
}
\examples{
data("platelet")
res <- blandAltman(x = platelet$Comparative, y = platelet$Candidate)
ESD_test(x = res@stat$relative_diff)
}
\references{
CLSI EP09A3 Appendix B. Detecting Aberrant Results (Outliers).
}
