% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcr.R
\name{mcreg}
\alias{mcreg}
\title{Comparison of Two Measurement Methods Using Regression Analysis}
\usage{
mcreg(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[mcr:mcreg]{mcr::mcreg}}
  \describe{
    \item{\code{x}}{measurement values of reference method, or two column matrix.}
    \item{\code{y}}{measurement values of test method.}
    \item{\code{error.ratio}}{ratio between squared measurement errors of reference and 
test method, necessary for Deming regression (Default 1).}
    \item{\code{alpha}}{value specifying the 100(1-alpha)\% confidence level for confidence intervals (Default is 0.05).}
    \item{\code{mref.name}}{name of reference method (Default "Method1").}
    \item{\code{mtest.name}}{name of test Method (Default "Method2").}
    \item{\code{sample.names}}{names of cases (Default "S##").}
    \item{\code{method.reg}}{regression method.  It is possible to choose between five regression methods: 
\code{"LinReg"} - ordinary least square regression.\cr 
\code{"WLinReg"} - weighted ordinary least square regression.\cr
\code{"Deming"} - Deming regression.\cr 
\code{"WDeming"} - weighted Deming regression.\cr
\code{"TS"} - Theil-Sen regression.\cr
\code{"PBequi"} - equivariant Passing-Bablok regression.\cr
\code{"PaBa"} - Passing-Bablok regression.\cr  
\code{"PaBaLarge"} - approximative Passing-Bablok regression for large datasets, operating on \code{NBins} classes of constant slope angle which each slope
                     is classified to instead of building the complete triangular matrix of all N*N/2 slopes.}
    \item{\code{method.ci}}{method of confidence interval calculation. The function 
contains four basic methods for calculation of confidence intervals for regression coefficients.
 \code{"analytical"} - with parametric method.\cr
 \code{"jackknife"} - with leave one out resampling.\cr
 \code{"bootstrap"} - with ordinary non-parametric bootstrap resampling.\cr
 \code{"nested bootstrap"} - with ordinary non-parametric bootstrap resampling.\cr}
    \item{\code{method.bootstrap.ci}}{bootstrap based confidence interval estimation method.}
    \item{\code{nsamples}}{number of bootstrap samples.}
    \item{\code{nnested}}{number of nested bootstrap samples.}
    \item{\code{rng.seed}}{integer number that sets the random number generator seed for bootstrap sampling. If set to NULL currently in the R session used RNG setting will be used.}
    \item{\code{rng.kind}}{type of random number generator for bootstrap sampling. Only used when rng.seed is specified, see set.seed for details.}
    \item{\code{iter.max}}{maximum number of iterations for weighted Deming iterative algorithm.}
    \item{\code{threshold}}{numerical tolerance for weighted Deming iterative algorithm convergence.}
    \item{\code{na.rm}}{remove measurement pairs that contain missing values (Default is FALSE).}
    \item{\code{NBins}}{number of bins used when 'reg.method="PaBaLarge"' to classify each slope in one of 'NBins' bins covering the range of all slopes}
    \item{\code{slope.measure}}{angular measure of pairwise slopes used for exact PaBa regression (see below for details).\cr
\code{"radian"} - for data sets with even sample numbers median slope is calculated as average of two central slope angles.\cr
\code{"tangent"} - for data sets with even sample numbers median slope is calculated as average of two central slopes (tan(angle)).\cr}
    \item{\code{methodlarge}}{Boolean. This parameter applies only to regmethod="PBequi" and "TS".
If TRUE, a quasilinear algorithm is used. 
If FALSE, a quadratic algorithm is used which is faster for less than several hundred data pairs.}
  }}
}
\value{
A regression fit model.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A copy from \link[mcr:mcreg]{mcr::mcreg} in \code{mcr} package
}
\examples{
data(platelet)
fit <- mcreg(
  x = platelet$Comparative, y = platelet$Candidate,
  method.reg = "Deming", method.ci = "jackknife"
)
printSummary(fit)
getCoefficients(fit)
}
\seealso{
\code{\link[mcr:mcreg]{mcr::mcreg()}}
}
