% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.R
\name{getRegcoeffs.pls}
\alias{getRegcoeffs.pls}
\title{Regression coefficients for PLS model'}
\usage{
\method{getRegcoeffs}{pls}(obj, ncomp = NULL, ny = NULL, full = FALSE,
  ...)
}
\arguments{
\item{obj}{a PLS model (object of class \code{pls})}

\item{ncomp}{number of components to return the coefficients for}

\item{ny}{if y is multivariate which variables you want to see the coefficients for}

\item{full}{if TRUE the method also shows p-values for the coefficients (if available)}

\item{...}{other parameters}
}
\value{
A matrix (n of predictors x n of responses) with regression coefficients.
}
\description{
Returns a matrix with regression coefficients for
the PLS model which can be applied to a data directly
}
\details{
The method recalculates the regression coefficients found by the PLS algorithm
taking into account centering and scaling of predictors and responses, so the 
matrix with coefficients can be applied directly to original data (yp = Xb).

If number of components is not specified, the optimal number, selected by user
or identified by a model will be used.
}

