/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.core.clusterings;

import multidendrograms.core.clusterings.HierarchicalClustering;
import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.core.definitions.SymmetricMatrix;

public class VersatileLinkage
extends HierarchicalClustering {
    private boolean isWeighted;
    private double power;

    public VersatileLinkage(SymmetricMatrix symmetricMatrix, String[] stringArray, boolean bl, int n, boolean bl2, double d) {
        super(symmetricMatrix, stringArray, bl, n);
        this.isWeighted = bl2;
        this.power = this.isDistanceBased ? d : -d;
    }

    @Override
    protected double calculateProximity(Dendrogram dendrogram, Dendrogram dendrogram2) {
        if (this.power == Double.NEGATIVE_INFINITY) {
            return this.minimumProximity(dendrogram, dendrogram2);
        }
        if (this.power == Double.POSITIVE_INFINITY) {
            return this.maximumProximity(dendrogram, dendrogram2);
        }
        if (this.power == 0.0) {
            return this.geometricMean(dendrogram, dendrogram2);
        }
        return this.generalizedMean(dendrogram, dendrogram2);
    }

    private double geometricMean(Dendrogram dendrogram, Dendrogram dendrogram2) {
        int n = dendrogram.numberOfSubroots();
        int n2 = dendrogram2.numberOfSubroots();
        int n3 = dendrogram.numberOfLeaves();
        int n4 = dendrogram2.numberOfLeaves();
        double d = 1.0;
        for (int i = 0; i < n; ++i) {
            Dendrogram dendrogram3 = dendrogram.getSubroot(i);
            double d2 = this.isWeighted ? 1.0 / (double)n : (double)dendrogram3.numberOfLeaves() / (double)n3;
            for (int j = 0; j < n2; ++j) {
                Dendrogram dendrogram4 = dendrogram2.getSubroot(j);
                double d3 = this.isWeighted ? 1.0 / (double)n2 : (double)dendrogram4.numberOfLeaves() / (double)n4;
                double d4 = this.rootsProximity(dendrogram3, dendrogram4);
                d *= Math.pow(d4, d2 * d3);
            }
        }
        return d;
    }

    private double generalizedMean(Dendrogram dendrogram, Dendrogram dendrogram2) {
        int n = dendrogram.numberOfSubroots();
        int n2 = dendrogram2.numberOfSubroots();
        int n3 = dendrogram.numberOfLeaves();
        int n4 = dendrogram2.numberOfLeaves();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            Dendrogram dendrogram3 = dendrogram.getSubroot(i);
            double d2 = this.isWeighted ? 1.0 / (double)n : (double)dendrogram3.numberOfLeaves() / (double)n3;
            for (int j = 0; j < n2; ++j) {
                Dendrogram dendrogram4 = dendrogram2.getSubroot(j);
                double d3 = this.isWeighted ? 1.0 / (double)n2 : (double)dendrogram4.numberOfLeaves() / (double)n4;
                double d4 = this.rootsProximity(dendrogram3, dendrogram4);
                d += d2 * d3 * Math.pow(d4, this.power);
            }
        }
        d = Math.pow(d, 1.0 / this.power);
        return d;
    }

    @Override
    protected double calculateInternalProximity(Dendrogram dendrogram) {
        if (this.power == Double.NEGATIVE_INFINITY) {
            return this.minimumInternalProximity(dendrogram);
        }
        if (this.power == Double.POSITIVE_INFINITY) {
            return this.maximumInternalProximity(dendrogram);
        }
        if (this.power == 0.0) {
            return this.geometricInternalMean(dendrogram);
        }
        return this.generalizedInternalMean(dendrogram);
    }

    private double geometricInternalMean(Dendrogram dendrogram) {
        double d = 1.0;
        int n = dendrogram.numberOfSubroots();
        int n2 = dendrogram.numberOfLeaves();
        for (int i = 0; i < n - 1; ++i) {
            Dendrogram dendrogram2 = dendrogram.getSubroot(i);
            double d2 = this.isWeighted ? 1.0 : (double)dendrogram2.numberOfLeaves();
            for (int j = i + 1; j < n; ++j) {
                Dendrogram dendrogram3 = dendrogram.getSubroot(j);
                double d3 = this.isWeighted ? 1.0 : (double)dendrogram3.numberOfLeaves();
                double d4 = this.rootsProximity(dendrogram2, dendrogram3);
                d *= Math.pow(d4, d2 * d3);
            }
        }
        double d5 = this.isWeighted ? 2.0 / (double)(n * (n - 1)) : 2.0 / (double)(n2 * (n2 - 1));
        d = Math.pow(d, d5);
        return d;
    }

    private double generalizedInternalMean(Dendrogram dendrogram) {
        double d = 0.0;
        int n = dendrogram.numberOfSubroots();
        int n2 = dendrogram.numberOfLeaves();
        for (int i = 0; i < n - 1; ++i) {
            Dendrogram dendrogram2 = dendrogram.getSubroot(i);
            double d2 = this.isWeighted ? 1.0 : (double)dendrogram2.numberOfLeaves();
            for (int j = i + 1; j < n; ++j) {
                Dendrogram dendrogram3 = dendrogram.getSubroot(j);
                double d3 = this.isWeighted ? 1.0 : (double)dendrogram3.numberOfLeaves();
                double d4 = this.rootsProximity(dendrogram2, dendrogram3);
                d += d2 * d3 * Math.pow(d4, this.power);
            }
        }
        double d5 = this.isWeighted ? 2.0 / (double)(n * (n - 1)) : 2.0 / (double)(n2 * (n2 - 1));
        d = Math.pow(d5 * d, 1.0 / this.power);
        return d;
    }
}

