/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import multidendrograms.definitions.Coordinates;
import multidendrograms.definitions.SettingsInfo;
import multidendrograms.dendrogram.Scaling;
import multidendrograms.dendrogram.eps.EpsUtils;
import multidendrograms.dendrogram.figures.Node;
import multidendrograms.types.DendrogramOrientation;
import multidendrograms.types.LabelOrientation;
import multidendrograms.types.PlotType;

public class NodeLabel {
    private LinkedList<Node> nodesList;
    private Font font;
    private Color color;
    private LabelOrientation labelOrientation;
    private DendrogramOrientation dendroOrientation;
    private DendrogramOrientation adaptedOrientation;
    private Scaling scalingDendro;

    public NodeLabel(LinkedList<Node> linkedList, SettingsInfo settingsInfo, Scaling scaling) {
        this.nodesList = linkedList;
        this.font = settingsInfo.getNodeNameFont();
        this.color = settingsInfo.getNodeNameColor();
        this.labelOrientation = settingsInfo.getNodeNameOrientation();
        this.dendroOrientation = settingsInfo.getDendrogramOrientation();
        this.adaptedOrientation = settingsInfo.getDendrogramAdaptedOrientation();
        this.scalingDendro = scaling;
    }

    public void draw(PlotType plotType, Graphics2D graphics2D) {
        Object object;
        double d = 0.0;
        if (this.labelOrientation.equals((Object)LabelOrientation.HORIZONTAL)) {
            d = 0.0;
        } else if (this.labelOrientation.equals((Object)LabelOrientation.VERTICAL)) {
            d = 90.0;
        } else if (this.labelOrientation.equals((Object)LabelOrientation.OBLIQUE)) {
            if (this.adaptedOrientation.equals((Object)DendrogramOrientation.NORTH) || this.adaptedOrientation.equals((Object)DendrogramOrientation.WEST)) {
                d = -45.0;
            } else if (this.adaptedOrientation.equals((Object)DendrogramOrientation.SOUTH) || this.adaptedOrientation.equals((Object)DendrogramOrientation.EAST)) {
                d = 45.0;
            }
        }
        AffineTransform affineTransform = new AffineTransform();
        if (plotType.equals((Object)PlotType.PANEL)) {
            affineTransform.rotate(Math.toRadians(-d));
        } else if (plotType.equals((Object)PlotType.EPS)) {
            affineTransform.rotate(Math.toRadians(d));
        }
        Font font = this.font.deriveFont(affineTransform);
        Color color = null;
        if (plotType.equals((Object)PlotType.PANEL)) {
            color = graphics2D.getColor();
            graphics2D.setColor(this.color);
        } else if (plotType.equals((Object)PlotType.EPS)) {
            EpsUtils.writeLine("gsave");
            EpsUtils.writeLine(EpsUtils.setRGBColor((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f));
            object = this.font.getPSName();
            if (((String)object).equals("Dialog.plain")) {
                EpsUtils.writeLine(EpsUtils.scaleSetFont("/ArialMT", this.font.getSize()));
            } else {
                EpsUtils.writeLine(EpsUtils.scaleSetFont("/" + (String)object, this.font.getSize()));
            }
        }
        object = null;
        if (plotType.equals((Object)PlotType.PANEL)) {
            object = new FontRenderContext(null, true, true);
        } else if (plotType.equals((Object)PlotType.EPS)) {
            object = new FontRenderContext(affineTransform, true, true);
        }
        for (Node node : this.nodesList) {
            Coordinates<Double> coordinates = this.getNameCoordinates(node, font, (FontRenderContext)object);
            double d2 = coordinates.getX();
            double d3 = coordinates.getY();
            String string = String.valueOf(node.getName());
            if (plotType.equals((Object)PlotType.PANEL)) {
                TextLayout textLayout = new TextLayout(string, font, (FontRenderContext)object);
                graphics2D.scale(1.0, -1.0);
                textLayout.draw(graphics2D, (float)d2, (float)(-d3));
                graphics2D.scale(1.0, -1.0);
                continue;
            }
            if (!plotType.equals((Object)PlotType.EPS)) continue;
            EpsUtils.writeLine(EpsUtils.bottomLeftTextRotated((float)((double)EpsUtils.xmin + d2), (float)((double)EpsUtils.ymax + d3), (float)d, string));
        }
        if (plotType.equals((Object)PlotType.PANEL)) {
            graphics2D.setColor(color);
        } else if (plotType.equals((Object)PlotType.EPS)) {
            EpsUtils.writeLine("grestore");
        }
    }

    private Coordinates<Double> getNameCoordinates(Node node, Font font, FontRenderContext fontRenderContext) {
        double d = 2.0 * node.getRadius();
        String string = String.valueOf(node.getName());
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getHeight();
        Coordinates<Double> coordinates = node.getPosReal();
        Coordinates<Double> coordinates2 = this.scalingDendro.transform(coordinates, this.dendroOrientation);
        double d4 = coordinates2.getX();
        double d5 = coordinates2.getY();
        if (this.labelOrientation.equals((Object)LabelOrientation.VERTICAL)) {
            if (this.adaptedOrientation.equals((Object)DendrogramOrientation.NORTH)) {
                d4 += d2 / 2.0;
                d5 += -d - d3;
            } else if (this.adaptedOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
                d4 += d2 / 2.0;
                d5 += d;
            } else if (this.adaptedOrientation.equals((Object)DendrogramOrientation.EAST)) {
                d4 += -d;
                d5 += -d3 / 2.0;
            } else {
                d4 += d + d2;
                d5 += -d3 / 2.0;
            }
        } else if (this.labelOrientation.equals((Object)LabelOrientation.HORIZONTAL)) {
            if (this.adaptedOrientation.equals((Object)DendrogramOrientation.NORTH)) {
                d4 += -d2 / 2.0;
                d5 += -d - d3;
            } else if (this.adaptedOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
                d4 += -d2 / 2.0;
                d5 += d;
            } else if (this.adaptedOrientation.equals((Object)DendrogramOrientation.EAST)) {
                d4 += -d - d2;
                d5 += -d3 / 2.0;
            } else {
                d4 += d;
                d5 += -d3 / 2.0;
            }
        } else if (this.adaptedOrientation.equals((Object)DendrogramOrientation.NORTH)) {
            d5 += -d;
        } else if (this.adaptedOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            d5 += d;
        } else if (this.adaptedOrientation.equals((Object)DendrogramOrientation.EAST)) {
            d4 += -d2;
            d5 += -d3;
        } else {
            d4 += d;
        }
        coordinates2.setX(d4);
        coordinates2.setY(d5);
        return coordinates2;
    }
}

