% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{MedicareCharges}
\alias{MedicareCharges}
\title{Charges to and Payments from Medicare}
\format{
A data frame with 5,025 observations on the following 4 variables.
\describe{ 
 \item{drg}{Code for the Diagnosis Related Group: a
character string that looks like a number.} 
 \item{stateProvider}{the state providing the care.} 
 \item{num_charges}{the total number of charges.}
 \item{mean_charge}{the average charge for each \code{drg} across each state}
 }
}
\source{
Data from the Centers for Medicare and Medicaid Services.
See \url{https://www.cms.gov/Research-Statistics-Data-and-Systems/Statistics-Trends-and-Reports/Medicare-Provider-Charge-Data/Inpatient}.
}
\usage{
MedicareCharges
}
\description{
These data for 2011, released in May 2013, describe how much hospitals
charged Medicare for various inpatient procedures, how many were performed,
and how much Medicare actually paid.
}
\details{
These data are part of a set with \code{DiagnosisRelatedGroup}, which gives a
description of the medical procedure associated with each DRG, and
\code{MedicareProviders}, which translates \code{idProvider} into a name,
address, state, Zip, etc..

These data have been pre-aggregated by state.
}
\examples{

data(MedicareCharges)

}
\references{
\url{https://hmsa.com/portal/provider/zav_pel.fh.DIA.650.htm}
}
\seealso{
\code{\link{MedicareProviders}}
}
\keyword{datasets}
