% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cusum.R
\name{cusum}
\alias{cusum}
\alias{cusum.mds_ts}
\alias{cusum.default}
\title{Cumuluative Sum (CUSUM)}
\usage{
cusum(df, ...)

\method{cusum}{mds_ts}(df, ts_event = c(Count = "nA"),
  analysis_of = NA, ...)

\method{cusum}{default}(df, analysis_of = NA, eval_period = NULL,
  delta = 1, H = NULL, zero_rate = 1/3, mu = NULL, sigma = NULL,
  ...)
}
\arguments{
\item{df}{Required input data frame of class \code{mds_ts} or, for generic
usage, any data frame with the following columns:
\describe{
  \item{time}{Unique times of class \code{Date}}
  \item{event}{Either the event count or rate of class \code{numeric}}
}}

\item{...}{Further arguments passed onto \code{cusum} methods}

\item{ts_event}{Required if \code{df} is of class \code{mds_ts}. Named string
indicating the variable corresponding to the event count or rate. Rate must
be calculated in a separate column in \code{df} as it is not calculated by
default. The name of the string is an English description of what was
analyzed.

Default: \code{c("Count"="nA")} corresponding to the event count column in
\code{mds_ts} objects. Name is generated from \code{mds_ts} metadata.

Example: \code{c("Rate of Bone Filler Events in Canada"="rate")}}

\item{analysis_of}{Optional string indicating the English description of what
was analyzed. If specified, this will override the name of the
\code{ts_event} string parameter.

Default: \code{NA} indicates no English description for plain \code{df}
data frames, or \code{ts_event} English description for \code{df} data frames
of class \code{mds_ts}.

Example: \code{"Rate of bone cement leakage"}}

\item{eval_period}{Optional positive integer indicating the number of unique
times counting in reverse chronological order to assess. This will be used to
establish the process mean and moving range.

Default: \code{NULL} considers all times in \code{df}.}

\item{delta}{Required number of sigmas at which to detect a mean shift.

Default: \code{1} detects a mean shift of one sigma.}

\item{H}{Optional positive number representing the decision interval bound.
Lower values will result in a more sensitive test.

Default: \code{NULL} uses a value of 5 times the estimated sigma.}

\item{zero_rate}{Required maximum proportion of \code{event}s in \code{df}
(constrained by \code{eval_period}) containing zeroes for this algorithm to
run. Because CUSUM does not perform well on time series with many 0 values,
a value >0 is recommended.

Default: \code{1/3} requires no more than 1/3 zeros in \code{event}s in
\code{df} in order to run.}

\item{mu}{Optional value of the in-control process mean, typically measured
from historical data.

Default: \code{NULL} estimates the in-control process mean from timepoints
prior to the most recent timepoint in the time series. The most recent
measurement is then tested using this estimate.}

\item{sigma}{Optional value of the in-control process standard deviation,
typically measured from historical data.

Default: \code{NULL} estimates the in-control process standard deviation
from timepoints prior to the most recent timepoint in the time series using
a moving range calculation assuming an n=2 sampling approach. The most recent
measurement is then tested using this estimate.}
}
\value{
A named list of class \code{mdsstat_test} object, as follows:
\describe{
  \item{test_name}{Name of the test run}
  \item{analysis_of}{English description of what was analyzed}
  \item{status}{Named boolean of whether the test was run. The name contains
  the run status.}
  \item{result}{A standardized list of test run results: \code{statistic}
  for the test statistic, \code{lcl} and \code{ucl} for the 95%
  confidence bounds, \code{p} for the p-value, \code{signal} status, and
  \code{signal_threshold}.}
  \item{params}{The test parameters}
  \item{data}{The data on which the test was run}
}
}
\description{
Test on device-events using the tabular CUSUM (CUmulative SUM) method.
}
\details{
Function \code{cusum()} is an implementation of the tabular CUSUM
method originally proposed by E.S. Page. CUSUM is part of the family of
statistical process control tests.
}
\section{Methods (by class)}{
\itemize{
\item \code{mds_ts}: CUSUM on mds_ts data

\item \code{default}: CUSUM on general data
}}

\examples{
# Basic Example
data <- data.frame(time=c(1:25), event=as.integer(stats::rnorm(25, 100, 25)))
a1 <- cusum(data)
# Example using an mds_ts object
a2 <- cusum(mds_ts[[3]])
# Example using a derived rate as the "event"
data <- mds_ts[[3]]
data$rate <- ifelse(is.na(data$nA), 0, data$nA) / data$exposure
a3 <- cusum(data, c(Rate="rate"))

}
\references{
Page, E. S. (June 1954). "Continuous Inspection Scheme". Biometrika. 41 (1/2): 100–115. doi:10.1093/biomet/41.1-2.100. JSTOR 2333009.
}
