% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{measr_extract}
\alias{measr_extract}
\alias{measr_extract.measrdcm}
\title{Extract components of a \code{measrfit} object.}
\usage{
measr_extract(model, ...)

\method{measr_extract}{measrdcm}(model, what, ppmc_interval = 0.95, quiet = FALSE, ...)
}
\arguments{
\item{model}{The estimated to extract information from.}

\item{...}{Additional arguments passed to specific methods.}

\item{what}{Character string. The information to be extracted. See details
for available options.}

\item{ppmc_interval}{The compatibility interval used for determining model
fit flags to return (e.g., \code{what = "odds_ratio_flags"}). For example, a
\code{ppmc_interval} of 0.95 will return any PPMCs where the posterior
predictive \emph{p}-value (ppp) is less than 0.025 or greater than 0.975.}

\item{quiet}{Logical. Should informational summaries and messages be
suppressed? Default is \code{FALSE}.}
}
\value{
The extracted information. The specific structure will vary depending
on what is being extracted, but usually the returned object is a
\link[tibble:tibble-package]{tibble} with the requested information.
}
\description{
Extract components of a \code{measrfit} object.

Extract components of an estimated diagnostic classification model
}
\details{
For diagnostic classification models, we can extract the following
information:
\itemize{
\item \code{item_param}: The estimated item parameters. This shows the name of the
parameter, the class of the parameter, and the estimated value.
\item \code{strc_param}: The estimated structural parameters. This is the base rate
of membership in each class. This shows the class pattern and the
estimated proportion of respondents in each class.
\item \code{prior}: The priors used when estimating the model.
\item \code{classes}: The possible classes or profile patterns. This will show the
class label (i.e., the pattern of proficiency) and the attributes
included in each class.
\item \code{class_prob}: The probability that each respondent belongs to class
(i.e., has the given pattern of proficiency).
\item \code{attribute_prob}: The proficiency probability for each respondent and
attribute.
\item \code{m2}: The \ifelse{html}{\out{M<sub>2</sub>}}{\eqn{M_2}} fit statistic,
including RMSEA and SRMSR indices. Model fit information must first be
added to the model using \code{\link[=add_fit]{add_fit()}}.
\item \code{odds_ratio}: The observed and posterior predicted odds ratios of each
item pair. Model fit information must first be added to the model using
\code{\link[=add_fit]{add_fit()}}.
\item \code{odds_ratio_flags}: A subset of the PPMC odds ratios where the \emph{ppp} is
outside the specified \code{ppmc_interval}.
\item \code{classification_accuracy}: The classification accuracy and consistency
for each attribute, using the metrics described by Johnson & Sinharay
(2018). Reliability information must first be added to the model using
\code{\link[=add_reliability]{add_reliability()}}.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{measr_extract(measrdcm)}: Extract components of an estimated diagnostic
classification model.

}}
\examples{
\dontshow{if (measr_examples()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
rstn_mdm_lcdm <- measr_dcm(
  data = mdm_data, missing = NA, qmatrix = mdm_qmatrix,
  resp_id = "respondent", item_id = "item", type = "lcdm",
  method = "optim", seed = 63277, backend = "rstan"
)

extract(rstn_mdm_lcdm, "strc_param")
\dontshow{\}) # examplesIf}
}
\references{
Johnson, M. S., & Sinharay, S. (2018). Measures of agreement to
assess attribute-level classification accuracy and consistency for
cognitive diagnostic assessments. \emph{Journal of Educational Measurement,
55}(4), 635-664. \doi{10.1111/jedm.12196}
}
