#' The soil_amp data
#'
#' The soil_amp data is the 16S rRNA gene amplicon sequencing dataset of Chinese wetland soils.
#' Reference: An et al. 2019 <doi:10.1016/j.geoderma.2018.09.035>; Liu et al. 2022 <10.1016/j.geoderma.2022.115866>
#'
#' @docType data
#' @keywords microtable
#' @name soil_amp
#' @usage data(soil_amp)
NULL

#' The soil_amp_network data
#'
#' The soil_amp_network data is a list storing three trans_network objects created based on soil_amp data.
#' Three networks are created for IW, CW and TW groups, respectively.
#'
#' @docType data
#' @keywords list
#' @name soil_amp_network
#' @usage data(soil_amp_network)
NULL

#' The soil_measure_diversity data
#'
#' The soil_measure_diversity data is a table storing all the abiotic factors and functional diversity based on the metagenomic sequencing and MetaCyc pathway analysis.
#'
#' @docType data
#' @keywords data.frame
#' @name soil_measure_diversity
#' @usage data(soil_measure_diversity)
NULL

#' The stool_met data
#'
#' The stool_met data is the metagenomic species abundance dataset of stool samples selected from R ExperimentHub package.
#' It has 198 samples, collected from the people with alcohol drinking habit, and 92 species.
#'
#' @docType data
#' @keywords microtable
#' @name stool_met
#' @usage data(stool_met)
NULL
