% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_mean.R
\name{el_mean}
\alias{el_mean}
\title{Empirical likelihood test for mean}
\usage{
el_mean(par, x, weights = NULL, control = list())
}
\arguments{
\item{par}{A numeric vector of parameter values to be tested.}

\item{x}{A numeric matrix, or an object that can be coerced to a numeric
matrix. Each row corresponds to an observation.}

\item{weights}{An optional numeric vector of weights.
Defaults to \code{NULL}, corresponding to identical weights.
If non \code{NULL}, weighted empirical likelihood is computed.}

\item{control}{A list of control parameters. See ‘Details’ in
\code{\link{el_eval}}.}
}
\value{
A list with class \code{"el_test"} as described in
  \code{\link{el_eval}}.
}
\description{
Computes empirical likelihood for mean parameter.
}
\examples{
## scalar mean
par <- 0
x <- rnorm(100)
el_mean(par, x)

## vector mean
par <- c(0, 0)
x <- matrix(rnorm(100L), ncol = 2)
el_mean(par, x)

## weighted EL
par <- c(0, 0)
x <- matrix(rnorm(100), ncol = 2)
el_mean(par, x, weights = rep(c(1,2), each = 25))
}
\references{
Glenn, N.L., and Yichuan Zhao. 2007.
  “Weighted Empirical Likelihood Estimates and Their Robustness Properties.”
  Computational Statistics & Data Analysis 51 (10): 5130–41.
  \doi{10.1016/j.csda.2006.07.032}.

Owen, Art. 1990. “Empirical Likelihood Ratio Confidence Regions.”
  The Annals of Statistics 18 (1).
  \doi{10.1214/aos/1176347494}.
}
\seealso{
\link{el_eval}
}
