% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/conv-methods.R
\name{conv}
\alias{conv}
\alias{conv,CEL-method}
\alias{conv,EL-method}
\alias{conv,ELT-method}
\alias{conv,SummaryEL-method}
\alias{conv,SummaryELT-method}
\alias{conv,SummaryLM-method}
\title{Convergence check}
\usage{
\S4method{conv}{CEL}(object, ...)

\S4method{conv}{EL}(object, ...)

\S4method{conv}{ELT}(object, ...)

\S4method{conv}{SummaryEL}(object, ...)

\S4method{conv}{SummaryELT}(object, ...)

\S4method{conv}{SummaryLM}(object, ...)
}
\arguments{
\item{object}{An object that contains the convergence status.}

\item{...}{Further arguments passed to methods.}
}
\value{
A single logical.
}
\description{
Extracts the convergence status from a model.
}
\section{Methods (by class)}{
\itemize{
\item \code{conv(CEL)}: Extracts the convergence status of the model with respect to
the parameter.

\item \code{conv(EL)}: Extracts the convergence status of the model with respect to
the Lagrange multiplier.

\item \code{conv(ELT)}: Extracts the convergence status of the test with respect to
the parameter (or the Lagrange multiplier if the argument \code{lhs} is \code{NULL}).

\item \code{conv(SummaryEL)}: Extracts the convergence status of the model with respect to
the Lagrange multiplier.

\item \code{conv(SummaryELT)}: Extracts the convergence status of the test with respect to
the parameter (or the Lagrange multiplier if the argument \code{lhs} is \code{NULL}).

\item \code{conv(SummaryLM)}: Extracts the convergence status of the model. See the
documentation of \linkS4class{EL} and \linkS4class{CEL}.

}}
\examples{
## Convergence check for the overall model test
data("mtcars")
fit <- el_lm(mpg ~ ., data = mtcars)
conv(fit)
}
\seealso{
\linkS4class{CEL}, \linkS4class{EL}, \linkS4class{ELT}, \code{\link[=getOptim]{getOptim()}}
}
