% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merlin_predict.R
\name{predict.merlin}
\alias{predict.merlin}
\title{predict.merlin - post-estimation tools for merlin}
\usage{
\method{predict}{merlin}(
  object,
  stat = "eta",
  type = "fixedonly",
  predmodel = 1,
  causes = NULL,
  at = NULL,
  contrast = NULL,
  ...
)
}
\arguments{
\item{object}{merlin model object}

\item{stat}{specifies which prediction, which can be one of:
\itemize{
  \item \code{eta} the expected value of the complex predictor
  \item \code{mu} the expected value of the response variable
  \item \code{hazard} the hazard function
  \item \code{chazard} the cumulative hazard function
  \item \code{logchazard} the log cumulative hazard function
  \item \code{survival} the survival function
  \item \code{cif} the cumulative incidence function
  \item \code{rmst} calculates the restricted mean survival time, which is the integral of the
  survival function within the interval (0,t], where t is the time at which predictions are made.
  If multiple survival models have been specified in your merlin model, then it will assume all
  of them are cause-specific competing risks models, and include them in the calculation. If
  this is not the case, you can override which models are included by using the \code{causes}
  option. \code{rmst = t - totaltimelost}.
  \item \code{timelost}  calculates the time lost due to a particular event occurring, within
  the interval (0,t].  In a single event survival model, this is the integral of the cif between
  (0,t].  If multiple survival models are specified in the merlin model then by default all are
  assumed to be cause-specific event time models contributing to the calculation. This can be
  overridden using the \code{causes} option.
  \item \code{totaltimelost} total time lost due to all competing events, within (0,t]. If multiple
  survival models are specified in the \code{merlin} model then by default all are assumed to
  be cause-specific event time models contributing to the calculation. This can be overridden
  using the \code{causes} option. \code{totaltimelost} is the sum of the \code{timelost} due to
  all causes.
  \item \code{cifdifference} calculates the difference in \code{cif} predictions between values 
  of a covariate specified using the \code{contrast} option.
  \item \code{hdifference} calculates the difference in \code{hazard} predictions between values 
  of a covariate specified using the \code{contrast} option. 
  \item \code{rmstdifference} calculates the difference in \code{rmst} predictions between values 
  of a covariate specified using the \code{contrast} option. 
  \item \code{mudifference} calculates the difference in \code{mu} predictions between values 
  of a covariate specified using the \code{contrast} option. 
  \item \code{etadifference} calculates the difference in \code{eta} predictions between values 
  of a covariate specified using the \code{contrast} option.  
}}

\item{type}{the type of prediction, either:
\itemize{
  \item \code{fixedonly} prediction calculated based only on the fixed effects; the default.
  \item \code{marginal} prediction calculated marginally with respect to the latent variables. the
  \code{stat} is calculated by integrating the prediction function with respect to all the latent
  variables over their entire support.
}}

\item{predmodel}{specifies which model to obtain predictions from; default is \code{predmodel=1}}

\item{causes}{is for use when calculating predictions from a competing risks \code{merlin} model.
By default, \code{cif}, \code{rmst}, \code{timelost} and \code{totaltimelost} assume that all
survival models included in the merlin model are cause-specific hazard models contributing to
the calculation. If this is not the case, then you can specify which models (indexed using
the order they appear in your merlin model by using the \code{causes} option, e.g.
\code{causes=c(1,2)}.}

\item{at}{specify covariate values for prediction. Fixed values of covariates should be specified
in a list e.g. at = c("trt" = 1, "age" = 50).}

\item{contrast}{specifies the values of a covariate to be used when comparing statistics, 
such as when using the \code{cifdifference} option to compare cumulative incidence functions, 
e.g. \code{contrast = c("trt" = 0, "trt" = 1)}.}

\item{...}{other options}
}
\description{
predictions following the fit of a merlin model
}
\examples{
library(merlin)
data(pbc.merlin, package = "merlin")

# Linear fixed-effects model
mod <-merlin(model = list(logb ~ year),
             family = "gaussian",
             data = pbc.merlin)
predict(mod,stat="eta",type="fixedonly")

}
\references{
Crowther MJ. Extended multivariate generalised linear and non-linear mixed
effects models. \url{https://arxiv.org/abs/1710.02223}

Crowther MJ. merlin - a unified framework for data analysis and methods development
in Stata. \url{https://arxiv.org/abs/1806.01615}

Martin EC, Gasparini A, Crowther MJ. merlin - an R package for mixed effects
regression of linear, non-linear and user-defined models.
}
\seealso{
\code{\link{merlin}}
}
\author{
Emma C. Martin, Alessandro Gasparini and Michael J. Crowther
}
