% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_contour_fill.R, R/stat_contour_fill.R
\docType{data}
\name{geom_contour_fill}
\alias{geom_contour_fill}
\alias{stat_contour_fill}
\alias{StatContourFill}
\title{Filled 2d contours of a 3d surface}
\usage{
geom_contour_fill(
  mapping = NULL,
  data = NULL,
  stat = "ContourFill",
  position = "identity",
  ...,
  breaks = MakeBreaks(),
  bins = NULL,
  binwidth = NULL,
  proj = NULL,
  clip = NULL,
  kriging = FALSE,
  global.breaks = TRUE,
  na.fill = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_contour_fill(
  mapping = NULL,
  data = NULL,
  geom = "polygon",
  position = "identity",
  ...,
  breaks = MakeBreaks(),
  bins = NULL,
  binwidth = NULL,
  global.breaks = TRUE,
  proj = NULL,
  clip = NULL,
  kriging = FALSE,
  na.fill = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{breaks}{numeric vector of breaks}

\item{bins}{Number of evenly spaced breaks.}

\item{binwidth}{Distance between breaks.}

\item{proj}{The projection to which to project the contours to.
It can be either a projection string or a function to apply to the whole
contour dataset.}

\item{clip}{A simple features object to be used as a clip. Contours are only
drawn in the interior of this polygon.}

\item{kriging}{Whether to perform ordinary kriging before contouring.
Use this if you want to use contours with irregularly spaced data.
If \code{FALSE}, no kriging is performed. If \code{TRUE}, kriging will be performed with
40 points. If a numeric, kriging will be performed with \code{kriging} points.}

\item{global.breaks}{Logical indicating whether \code{breaks} should be computed for the whole
data or for each grouping.}

\item{na.fill}{How to fill missing values.
\itemize{
\item \code{FALSE} for letting the computation fail with no interpolation
\item \code{TRUE} for imputing missing values with \link{Impute2D}
\item A numeric value for constant imputation
\item A function that takes a vector and returns a numeric (e.g. \code{mean})
}}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom}{The geometric object to use to display the data, either as a
\code{ggproto} \code{Geom} subclass or as a string naming the geom stripped of the
\code{geom_} prefix (e.g. \code{"point"} rather than \code{"geom_point"})}
}
\description{
While ggplot2's \code{\link[ggplot2]{geom_contour}} can plot nice contours, it
doesn't work with the polygon geom. This stat makes some small manipulation
of the data to ensure that all contours are closed and also computes a new
aesthetic \code{int.level}, which differs from \code{level} (computed by
\link[ggplot2:geom_contour]{ggplot2::geom_contour}) in that represents
the value of the \code{z} aesthetic \emph{inside} the contour instead of at the edge.
It also computes breaks globally instead of per panel, so that faceted plots
have all the same binwidth.
}
\section{Aesthetics}{

\code{geom_contour_fill} understands the following aesthetics (required aesthetics are in bold):

\itemize{
\item \strong{x}
\item \strong{y}
\item \code{alpha}
\item \code{colour}
\item \code{group}
\item \code{linetype}
\item \code{size}
\item \code{weight}
}
}

\section{Computed variables}{

\describe{
\item{level}{An ordered factor that represents bin ranges.}
\item{level_d}{Same as \code{level}, but automatically uses \code{\link[=scale_fill_discretised]{scale_fill_discretised()}}}
\item{level_low,level_high,level_mid}{Lower and upper bin boundaries for each band, as well the mid point between the boundaries.}
}
}

\examples{
\dontshow{data.table::setDTthreads(1)}

library(ggplot2)
surface <- reshape2::melt(volcano)
ggplot(surface, aes(Var1, Var2, z = value)) +
  geom_contour_fill() +
  geom_contour(color = "black", size = 0.1)

ggplot(surface, aes(Var1, Var2, z = value)) +
  geom_contour_fill(aes(fill = after_stat(level)))

ggplot(surface, aes(Var1, Var2, z = value)) +
  geom_contour_fill(aes(fill = after_stat(level_d)))

}
\seealso{
Other ggplot2 helpers: 
\code{\link{MakeBreaks}()},
\code{\link{WrapCircular}()},
\code{\link{geom_arrow}()},
\code{\link{geom_contour2}()},
\code{\link{geom_label_contour}()},
\code{\link{geom_relief}()},
\code{\link{geom_streamline}()},
\code{\link{guide_colourstrip}()},
\code{\link{map_labels}},
\code{\link{reverselog_trans}()},
\code{\link{scale_divergent}},
\code{\link{scale_longitude}},
\code{\link{stat_na}()},
\code{\link{stat_subset}()}
}
\concept{ggplot2 helpers}
\keyword{datasets}
