% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siteFinder.R
\name{siteFinder}
\alias{siteFinder}
\title{Filter environmental monitoring stations (wrapper)}
\usage{
siteFinder(country = NULL, siteID = NULL, lat = 39.833333,
  lon = -98.583333, radius = 50, network = NULL, vars = "temperature",
  id = NULL, startDate = NULL, endDate = "2006-01-27",
  includeUnk = TRUE, elevThresh = NULL, ...)
}
\arguments{
\item{country}{(character) Country(ies)/territory(ies) to filter environmental stations. Defaults to NULL (entire database will be returned).}

\item{siteID}{(character) "idType:id" NULL if iniltializing \code{lat} & \code{lon}. Required if \code{lat} & \code{lon} are set to NULL.}

\item{lat}{(numeric) Latitude of Point of interest (POI). Defaults to 40.0149, i.e., latitude of Boulder, CO, USA\cr}

\item{lon}{(numeric) Longitude of Point of interest (POI). Defaults to -105.2705, i.e., longitude of Boulder, CO, USA\cr}

\item{radius}{(numeric) Search radius outward from POI for finding environmental monitoring stations. Defined in kilometers (km) and defaults to 50.\cr}

\item{network}{(character) Network(s)/platform(s) to filter environmental monitoring stations. Defaults to NULL.  Metadata are available for stations in the networks below.  An individual station may be part of multiple networks.  See reference links for further information.\cr}

\item{vars}{(character) Elements(s)/variables(s) of interest.  Defaults to NULL.  The user can search for general, environmental terms, such as 'temperature,' or 'wind,' and the function will return environmental stations that collect the specified elements.  Keep in mind that the database contains ~107,000 stations, worldwide.  Searching for a general term such as 'temperature' will return many stations. The user is advised to search for more granular terms, e.g., using subTerms such as 'air temperature,' or 'soil temperature,' if they wish to narrown their results.}

\item{id}{(character) identifier(s) of interest.  Defaults to NULL. Metadata are available for stations with any of the identifiers listed below. Note that a single station can have multiple, associated identifers.  See reference links for further information.\cr}

\item{startDate}{(character) "YYY-MM-DD" to filter start dates of environmental stations within the metScanR database. Optional if \code{endDate} is initialized. Required if \code{endDate} is NULL.}

\item{endDate}{(character) "YYY-MM-DD" to filter end dates of environmental stations within the metScanR  database. Optional if \code{startDate} is initialized. Required if \code{startDate} is NULL.}

\item{includeUnk}{(logical) Defaults to FALSE and excludes sites with unknown start dates.  Setting to TRUE will include sites with unknown start dates.  Sites without known start dates account for ~71 percent of the metScanR database.  This is a result of undocumented, government (or network/governing body) metadata. Nearly all stations within the database have a known end date, however.  Setting startDate=NULL, initializing endDate, and setting includeUnk=TRUE will more than likely return results than if startDate is also initialized.}

\item{elevThresh}{(numeric) defines elevation range to filter metadata.  Units are in meters (m).  If \code{elevThresh} is a single value, the function will return sites within the database that have elevations less than or equal to \code{elevThresh}. Alternatively, if \code{elevThresh} is a numeric vector of length = 2, the function will assign the first component as a midpoint elevation, and the second component as a threshold (range), e.g., \code{elevThresh}=c(100,50) will return sites that have elevations within 100 +/- 50 (m) Above Sea Level.}

\item{...}{Depracated terms from previous version of function.}
}
\value{
A list comprising metadata of environmental monitoring stations from country(ies)/territory(ies) specified in \code{country}\cr
}
\description{
A wrapper function comprising all filtering functions within the metScanR package.  The metScanR database contains metadata from roughly 107,000 stations among ~200 countries/territories and ~18 networks/platforms, worldwide.   This function returns metadata for a subset of those stations, based on the criteria specified by a user.
}
\examples{
\dontrun{
#Return metadata of sites within 50 km of NEON's HARV active from 1965-10-20 to 1986-09-02
  siteFinder(siteID="NEON:HARV",startDate="1965-10-20",
  endDate="1986-09-02",radius=50)

#Return metadata of SCAN, SNTL, and ASOS sites active from at least 2000-01-05 onward
  siteFinder(network=c("SCAN","SNTL","ASOS"),startDate="2000-01-05")

#Return metadata of sites in Brazil with elevations of 1500 +/- 250 (m) Above Sea Level
  siteFinder(elevThresh=c(1500,250),country="Brazil")}
}
\seealso{
\link[metScanR]{getNearby}
\link[metScanR]{getElevation}
\link[metScanR]{getDates}
\link[metScanR]{getNetwork}
\link[metScanR]{getVars}
\link[metScanR]{getCountry}
\link[metScanR]{getId}
\link[metScanR]{mapSiteFinder}
\link[metScanR]{metScanR_DB}
}
\author{
Josh Roberti \email{jaroberti87@gmail.com} \cr
Cody Flagg \cr
Lee Stanish \cr
Sam Weintraub \cr
Derek Smith
}
\keyword{atmopsheric}
\keyword{atmosphere,}
\keyword{climate,}
\keyword{data,}
\keyword{environment,}
\keyword{environmental}
\keyword{in-situ,}
\keyword{meteorological}
\keyword{meteorology,}
\keyword{weather,}
