% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta-transf.R
\name{meta-transf}
\alias{meta-transf}
\alias{transf}
\alias{cor2z}
\alias{p2asin}
\alias{p2logit}
\alias{VE2logVR}
\alias{backtransf}
\alias{asin2ir}
\alias{asin2p}
\alias{logit2p}
\alias{logVR2VE}
\alias{z2cor}
\title{Auxiliary functions for (back) transformations}
\usage{
transf(x, sm, func = NULL, args = NULL)

cor2z(x)

p2asin(x)

p2logit(x)

VE2logVR(x)

backtransf(x, sm, n, time, func = NULL, args = NULL)

asin2ir(x, time = NULL)

asin2p(x, n = NULL)

logit2p(x)

logVR2VE(x)

z2cor(x)
}
\arguments{
\item{x}{Numerical vector with effect estimates, lower or upper
confidence / prediction interval limit(s).}

\item{sm}{Summary measure.}

\item{func}{User-specified function for (back) transformation.}

\item{args}{Function arguments for user-specified function.}

\item{n}{Sample size(s) to back transform Freeman-Tukey transformed
proportions.}

\item{time}{Time(s) to back transform Freeman-Tukey transformed
incidence rates.}
}
\description{
Auxiliary functions to (back) transform effect estimates or
confidence / prediction interval limit(s).
}
\details{
Often in a meta-analysis, effect estimates are transformed before
calculating a weighted average. For example, the log odds ratio and
its standard error is used instead of the odds ratio in R function
\code{\link{metagen}}. To report the results of a meta-analysis,
effect estimates are typically back transformed to the original
scale. R package \bold{meta} provides some auxiliary functions for
(back) transformations.

\subsection{Transformations}{
The following auxiliary functions are provided by R package
\bold{meta} to transform effect estimates or confidence /
prediction interval limits.

\tabular{ll}{
\bold{Function} \tab \bold{Transformation} \cr
\code{cor2z} \tab Correlations to Fisher's Z transformed correlations \cr
\code{p2logit} \tab Proportions to logit transformed proportions \cr
\code{p2asin} \tab Proportions to arcsine transformed proportions \cr
\code{VE2logVR} \tab Vaccine efficacy / effectiveness to log vaccine ratio
}

Note, no function for the Freeman-Tukey arcsine transformation is
provided as this transformation is based on the number of events
and sample sizes instead of the effect estimates.

R function \code{transf} is a wrapper function for the above and
additional transformations, e.g., the log transformation using
\code{\link[base]{log}} for odds or risk ratios. Argument \code{sm}
is mandatory to specify the requested transformation. It is also
possible to specify a different function with arguments \code{func}
and \code{args}.
}

\subsection{Back transformations}{
The following auxiliary functions are available to back transform
effect estimates or confidence / prediction interval limits.

\tabular{ll}{
\bold{Function} \tab \bold{Transformation} \cr
\code{asin2ir} \tab Freeman-Tukey arcsine transformed rates to rates \cr
\code{asin2p} \tab (Freeman-Tukey) arcsine transformed proportions to proportions \cr
\code{logit2p} \tab Logit transformed proportions to proportions \cr
\code{logVR2VE} \tab Log vaccine ratio to vaccine efficacy / effectiveness \cr
\code{z2cor} \tab Fisher's Z transformed correlations  to correlations
}

Argument \code{time} is mandatory in R function \code{asin2ir}.

If argument \code{n} is provided in R function \code{asin2p},
Freeman-Tukey arcsine transformed proportions are
back transformed. Otherwise, arcsine transformed proportions are
back transformed.

R function \code{backtransf} is a wrapper function for the above
and additional transformations, e.g., the exponential
transformation using \code{\link[base]{exp}} for log odds or log
risk ratios. Argument \code{sm} is mandatory to specify the
requested transformation. For the Freeman-Tukey transformations,
argument \code{n} or \code{time} is mandatory.

It is also possible to specify a different function with arguments
\code{func} and \code{args}.
}
}
\examples{
logit2p(p2logit(0.5))

}
\seealso{
\code{\link{meta-sm}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
