% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_forest.R
\name{plot_forest}
\alias{plot_forest}
\title{Forest Plot for Meta-Analysis}
\usage{
plot_forest(meta, from = 0, to = 1, shrinked = "Random Effects",
  summary = c("Mean", "HPD"), mar = c(4.5, 12, 4, 0.3), ...)
}
\arguments{
\item{meta}{fitted meta-analysis model}

\item{from}{lower limit of the x-axis}

\item{to}{upper limit of the x-axis}

\item{shrinked}{which meta-analysis model should be used to show (shrinked) estimates of the study effect sizes. The name must match the corresponding name in the list \code{meta}. Can be suppressed by \code{shrinked = ""}}

\item{summary}{character vector with two values: first, either \code{"Mean"} or \code{"Median"}; and second, either highest-probability-density interval (\code{"HPD"}) or the quantile interval (\code{"quantile"}; function resets margin to default after plotting)}

\item{mar}{margin of the plot in the order \code{c(bottom, left, top, right)} (see \code{\link[graphics]{par}})}

\item{...}{arguments passed to \code{\link[graphics]{plot}} (e.g., \code{from}, \code{to})}
}
\description{
Plots estimated effect sizes for all studies.
}
\examples{
data(towels)
mf <- meta_fixed(towels$logOR, towels$SE, towels$study)
plot_forest(mf, mar = c(4.5,20,4,.2), xlab="Log Odds Ratio")
}
\seealso{
\link{meta_default}, \link{meta_bma}, \link{meta_fixed}, \link{meta_random}
}
