% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submnet.R
\name{scoreGeneDel}
\alias{scoreGeneDel}
\title{Structure of Class "scoreGeneDel"}
\usage{
scoreGeneDel(
  model = NULL,
  condition = NA,
  fitness.random = NULL,
  fitness.ranks = NULL,
  fitness.id.random = NULL,
  fitness.id.ranks = NULL,
  ess.gene = NULL,
  ess.reaction = NULL,
  gene.del = NULL,
  gene.sets = NULL,
  ratio.GS = NULL,
  sub.genes = NULL,
  sub.reacs = NULL,
  sub.metas = NULL,
  rescue.met = NULL
)
}
\arguments{
\item{model}{An object of class \code{modelorg} indicating the weighted \code{rescue} model obtained from the rescue process.}

\item{condition}{The experimental condition ID.}

\item{fitness.random}{Random-based fitness with weighting scheme.}

\item{fitness.ranks}{Ranks-based fitness with weighting scheme.}

\item{fitness.id.random}{Random-based fitness without weighting scheme.}

\item{fitness.id.ranks}{Ranks-based fitness without weighting scheme.}

\item{ess.gene}{Percentages of essential genes. The computation of essentiality is deprecated in this version.}

\item{ess.reaction}{Percentages of essential reactions. The computation of essentiality is deprecated in this version.}

\item{gene.del}{Number of deleted genes.}

\item{gene.sets}{Gene sets.}

\item{ratio.GS}{Percentages of remaining genes in each gene set.}

\item{sub.genes}{Remaining genes in submodels after propagation.}

\item{sub.reacs}{Remaining reactions in submodels after propagation.}

\item{sub.metas}{Remaining metabolites in submodels after propagation.}

\item{rescue.met}{Fraction of every rescued metabolite among random draws.}
}
\value{
An object of class \code{scoreGeneDel}.
}
\description{
Structure of the class \code{scoreGeneDel}. Objects of this class are returned by the function submnet.
}
\examples{
data(yarliSubmnets)
attributes(yarliSubmnets[[1]])
}
