% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modularity.R
\name{Modularity}
\alias{Modularity}
\title{Calculates Barber's Bipartite Modularity}
\usage{
Modularity(comm, method = "tswap", sims = 1000, scores = 1,
  order = TRUE, c = length(comm), nstarts = 100, returnModules = FALSE)
}
\arguments{
\item{comm}{community data in the form of a presence absence matrix}

\item{method}{null model randomization method used by \code{NullMaker}. See
details below (and the help file of fucntion \code{NullMaker}) for more
information.}

\item{sims}{number of simulated null matrices to use in analysis}

\item{scores}{axis scores to ordinate matrix. 1: primary axis scores
(default) 2: secondary axis scores}

\item{order}{logical argument indicating whether to ordinate the interaction
matrix or not. See details.}

\item{c}{starting guess for the number of modules present. Defaults to the
maximum number of modules possible.}

\item{nstarts}{number of starts. Default is 100. More will both slow the
function down, and increase the likelihood of converging on the true
modularity value.}

\item{returnModules}{logical argument indicating whether to return a vector of module IDs}
}
\value{
A vector containing Barber's modularity statistic (Q), the z statistic comparing observed modularity against null matrices (z), p-value (pval), and mean (simulatedMean) and variance (simulatedVariance) from null model simulations
}
\description{
Modularity, community formation, boundary clumping. Call it what you want,
there is a fair amount of overlap in definition here. As such, we posit that
modularity statistics may be able to detect boundary clumping better than
Morisita's index. We offer a function here to calculate modularity.
Specifically, this function calculates Barber's Q statistic, and compares it
relative to null model randomizations.
}
\details{
\code{method} is an argument handed to functions in the \code{vegan}
package. Leibold & Mikkelson advocated the use of equiprobable rows and
columns (provided that rows and columns had at least one entry). This method
is called \code{r00}. Methods maintaining row (site) frequencies include
\code{r0},\code{r1}, and \code{r2}. The default method argument is
\code{r1}, which maintains the species richness of a site (row totals) and
fills species ranges (columns) based on their marginal probabilities.
Arguably the most conservative null algorithm is the fixed row - fixed
column total null, which can be attained using many of swap algorithms
described in the vegan package (sequential methods like \code{tswap},
\code{swap}, and non-sequential \code{quasiswap} and \code{backtracking}).
See the help file for \code{commsim} or Wright et al. 1998 for more
information.

If \code{order} is FALSE, the interaction matrix is not ordinated, allowing
the user to order the matrix based on site characteristics or other
biologically relevant characteristics.
}
\examples{

#define an interaction matrix
data(TestMatrices)
intmat <- TestMatrices[[3]]

#determine Barber"s modularity
mod.intmat <- Modularity(intmat, method="r1", sims=5,
 scores=1, order=TRUE, nstarts=10)

#return results
mod.intmat

}
\author{
Tomlin Pulliam and Tad Dallas
}
\references{
Barber, M. J. 2007. Modularity and community detection in bipartite
networks. Physical Review E, 76(6), 066102.

Leibold, M.A. and G.M. Mikkelson. 2002. Coherence, species turnover, and
boundary clumping: elements of meta-community structure. Oikos 97: 237 -
250.

Wright, D.H., Patterson, B.D., Mikkelson, G.M., Cutler, A. & Atmar, W.
(1998). A comparative analysis of nested subset patterns of species
composition. Oecologia 113, 1-20.
}

