% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PDFs_collect.R
\name{PDFs_collect}
\alias{PDFs_collect}
\title{Attempts to download PDFs from multiple DOI links.}
\usage{
PDFs_collect(aDataFrame, DOIcolumn, FileNamecolumn, directory = "downloads",
  validatePDF = TRUE, quiet = FALSE, showSummary = TRUE)
}
\arguments{
\item{aDataFrame}{A data frame containing a column of DOIs and a column of
individual file names for each downloaded PDF.}

\item{DOIcolumn}{The label of the column containing all the DOI links.}

\item{FileNamecolumn}{The label of the column containing all the strings
that will be used to rename the downloaded files.}

\item{directory}{A string of the location (directory) were downloaded PDF
files are to be saved.  NOTE: helps to have this directory created before
initializing the \code{PDFs_collect} function.}

\item{validatePDF}{When \code{TRUE} will only save to files that are valid
PDF documents.  When \code{FALSE} will save all candidate files, even if
they are not valid PDF formats.}

\item{quiet}{When \code{FALSE} does not print to console individual
download progress and summary.}

\item{showSummary}{When \code{FALSE} does not print overall summary of download
   successes and failures.}
}
\value{
The data frame with new column containing download-outcome successes.
}
\description{
Tries to download a collection of PDF files using multiple digital object
identifier (DOI) links.  Updates a data frame with the success of these
downloads.  The function is a wrapper for \code{\link{PDF_download}}.  NOTE: A
single DOI may generate multiple PDF files.
}
\examples{
\dontrun{

data(example_references_metagear)
someRefs <- effort_initialize(example_references_metagear)
dir.create("metagear_downloads")
PDFs_collect(aDataFrame = someRefs, DOIcolumn = "DOI",
             FileNamecolumn = "STUDY_ID", directory = "metagear_downloads")
}
}
\seealso{
\code{\link{PDF_download}}
}

