% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knowledge_weighted_estimate.R
\name{knowledge_weighted_estimate}
\alias{knowledge_weighted_estimate}
\title{Knowledge-Weighted Estimate}
\usage{
knowledge_weighted_estimate(E, P)
}
\arguments{
\item{E}{Vector of \eqn{J \ge 5} estimates of the outcome.}

\item{P}{Vector of \eqn{J \ge 5} predictions of others. The values must be in the same order as the estimates in \code{E}.
Specifically, for all \eqn{j = 1, ..., J}, \code{E[j]} and \code{P[j]} give the \eqn{j}th judge's estimate and prediction of others, respectively.}
}
\value{
The knowledge-weighted estimate
}
\description{
This function computes the knowledge-weighted estimate from \emph{Palley & Satopää (2020):
Boosting the Wisdom of Crowds Within a Single Judgment Problem: Weighted Averaging Based on Peer Predictions}.
The current version of the paper is available at \url{https://papers.ssrn.com/sol3/Papers.cfm?abstract_id=3504286}
}
\examples{
# Illustration on the Three Gorges Dam Example in Palley & Satopää (2020):

# Judges' estimates:
E = c(50, 134, 206, 290, 326, 374)
# Judges' predictions of others
P = c(26, 92, 116, 218, 218, 206)

# Knowledge-weighted estimate is 329.3266
knowledge_weighted_estimate(E,P)
}
