% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metapred_recalibrate.R
\name{recalibrate}
\alias{recalibrate}
\title{Recalibrate a Prediction Model}
\usage{
recalibrate(object, newdata, f = ~1, estFUN = NULL, ...)
}
\arguments{
\item{object}{A model fit object to be recalibrated, of class \code{metapred, glm} or \code{lm}, and more.}

\item{newdata}{data.frame containing new data set for updating.}

\item{f}{formula. Which coefficients of the model should be updated? Default: intercept only. Left-hand side may
be left out. See \link[stats]{formula} for details.}

\item{estFUN}{Function for model estimation. If left \code{NULL}, the function is automatically retrieved
for \code{metapred} objects. For other objects, the function with name corresponding to the first class
of the object is taken. E.g. \code{glm()} for \code{glm} objects.}

\item{...}{Optional arguments to pass to \code{estFUN}.}
}
\value{
Recalibrated model fit object, of the same class as \code{object}. Generally, updated coefficients can
be retrieved with \code{coef()}.
}
\description{
\code{recalibrate} is used to recalibrate a prediction model of classes \code{metapred, glm} or  \code{lm}.
}
\details{
Currently only the coefficients are updated and the variances and other aspects are left untouched. 
For updating the entire model and all its statistics, see \link[stats]{update}.
}
\examples{
data(DVTipd)
DVTipd$cluster <- 1:4 # Add a fictional clustering to the data set.
# Suppose we estimated the model in three studies: 
DVTipd123 <- DVTipd[DVTipd$cluster <= 3, ]
mp <- metamisc:::metapred(DVTipd123, strata = "cluster", f = dvt ~ vein + malign, 
family = binomial)
# and now want to recalibrate it for the fourth:
DVTipd4 <- DVTipd[DVTipd$cluster == 4, ]
metamisc:::recalibrate(mp, newdata = DVTipd4)

}
