% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uvmeta.r
\name{uvmeta}
\alias{uvmeta}
\title{Univariate meta-analysis}
\usage{
uvmeta(r, r.se, method = "REML", test = "knha", labels, na.action,
  n.chains = 4, pars, ret.fit = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{r}{Vector of numerics containing the effect size of each study}

\item{r.se}{Vector of numerics containing the standard error of the effect sizes}

\item{method}{Character string specifying whether a fixed-effect or a random-effects model should be fitted. 
A fixed-effect model is fitted when using \code{method="FE"}. Random-effects models are fitted by setting method equal 
to one of the following: \code{"REML"} (Default), \code{"DL"}, \code{"HE"}, \code{"SJ"}, \code{"ML"}, \code{"EB"}, 
\code{"HS"}, \code{"GENQ"} or \code{"BAYES"}. See 'Details'.}

\item{test}{Optional character string when \code{method!="BAYES"} to specify how test statistics and confidence intervals 
for the fixed effects should be computed. By default (\code{test="knha"}), the method by Knapp and Hartung (2003) is used for adjusting test statistics 
and confidence intervals.  Type '\code{?rma}' for more details.}

\item{labels}{Vector of characters containing the labels for the studies}

\item{na.action}{A function which indicates what should happen when the data contain NAs. 
Defaults to \code{"na.fail"}, other options are \code{"na.omit"}, \code{"na.exclude"} or \code{"na.pass"}.}

\item{n.chains}{Optional numeric specifying the number of chains to use in the Gibbs sampler (\code{method="BAYES"}). 
More chains will improve the sensitivity of the convergence diagnostic, but will cause the simulation to run more slowly. 
The default number of chains is 4.}

\item{pars}{Optional list with additional arguments. The width of confidence, credibility and prediction intervals is 
defined by \code{level} (defaults to 0.95). 
The following parameters configure the MCMC sampling procedure:  
\code{hp.mu.mean} (Hyperparameter: mean of the prior distribution of the fixed/random effects model, defaults to zero), 
\code{hp.mu.var} (Hyperparameter: variance of the prior distribution of the fixed/random effects model, defaults to 1000),
\code{hp.tau.min} (Hyperparameter: mininum value for the between-study standard deviation, defaults to 0),
\code{hp.tau.max} (Hyperparameter: maximum value for the between-study standard deviation, defaults to 100).}

\item{ret.fit}{logical indicating whether the full results from the fitted model should also be returned.}

\item{verbose}{If TRUE then messages generated during the fitting process will be displayed.}

\item{\dots}{Additional arguments that are passed to \pkg{rma} or \pkg{runjags} (if \code{method="BAYES"}).}
}
\value{
An object of the class \code{uvmeta} for which many standard methods are available.
\describe{
 \item{"data"}{array with (transformed) data used for meta-analysis, and method(s) used for restoring missing information. }
 \item{"method"}{character string specifying the meta-analysis method.}
 \item{"est"}{estimated performance statistic of the model. For Bayesian meta-analysis, the posterior median is returned.}
 \item{"se"}{standard error (or posterior standard deviation) of the summary estimate.}
 \item{"tau2"}{estimated amount of (residual) heterogeneity. Always 0 when method=\code{"FE"}. For Bayesian meta-analysis, the posterior median is returned.}
 \item{"se.tau2"}{estimated standard error (or posterior standard deviation) of the between-study variation.}
 \item{"ci.lb"}{lower bound of the confidence (or credibility) interval of the summary estimate}
 \item{"ci.ub"}{upper bound of the confidence (or credibility) interval of the summary estimate}
 \item{"pi.lb"}{lower bound of the (approximate) prediction interval of the summary estimate}
 \item{"pi.ub"}{upper bound of the (approximate) prediction interval of the summary estimate}
 \item{"fit"}{the full results from the fitted model}
 \item{"slab"}{vector specifying the label of each study.}
}
}
\description{
This function summarizes multiple estimates for a single parameter by assuming a fixed (i.e. common) 
effect or random effects across studies. The summary estimate is obtained by calculating a weighted mean that accounts for
sample size and (in case random effects are assumed) for between-study heterogeneity.
}
\details{
Unless specified otherwise, all meta-analysis models assume random effects and are fitted  using restricted 
maximum likelihood estimation with the \pkg{metafor} package (Viechtbauer 2010).  Further, confidence intervals for 
the average performance are based on the Hartung-Knapp-Sidik-Jonkman method, to better account for the uncertainty 
in the estimated between-study heterogeneity (Debray 2016). A Bayesian meta-analysis can be performed by specifying 
\code{method="BAYES"}. In that case, the R packages \pkg{runjags} and \pkg{rjags} must be installed.]\cr
\cr
For random-effects models, a prediction interval for the pooled effect size is displayed. This interval predicts in what 
range future effect sizes will fall given what has already been observed (Higgins 2009, Riley 2011).  

\subsection{Bayesian meta-analysis models}{
For Bayesian meta-analysis models that involve the Gibbs sampler (\code{method="BAYES"}), the R packages \code{runjags} 
and \code{rjags} must be installed. The Bayesian approach uses an uninformative Normal prior for the mean and a 
uniform prior for the between-study variance of the pooled effect size (Higgins 2009). By default, the Normal prior 
has a mean of 0 and a variance of 1000. These hyperparameters can, however, be altered through the 
variables \code{hp.mu.mean} and \code{hp.mu.var} in the argument \code{pars}. The prior distribution of the between-study 
standard deviation is given by a uniform distribution, by default bounded between 0 and 100. 
}
}
\examples{
data(Roberts)

# Frequentist random-effects meta-analysis
fit1 <- with(Roberts, uvmeta(r=SDM, r.se=SE, labels=rownames(Roberts)))
summary(fit1)
plot(fit1) #show a forest plot
fit1

\dontrun{
# Bayesian random effects meta-analysis 
fit2 <- with(Roberts, uvmeta(r=SDM, r.se=SE, labels=rownames(Roberts), method="BAYES"))
plot(fit2)
}

}
\references{
\itemize{
\item Biggerstaff BJ, Tweedie RL. Incorporating variability in estimates of heterogeneity in the random effects model 
in meta-analysis. \emph{Statistics in Medicine} 1997; \bold{16}:  753--768.
\item Borenstein M, Hedges LV, Higgins JPT, Rothstein HR. A basic introduction to fixed-effect and random-effects 
models for meta-analysis. \emph{Research Synthesis Methods} 2010; \bold{1}: 97--111.
\item DerSimonian R, Laird N. Meta-analysis in clinical trials. \emph{Controlled Clinical Trials} 1986; \bold{7}: 177--188.
\item Graham PL, Moran JL. Robust meta-analytic conclusions mandate the provision of prediction intervals in 
meta-analysis summaries. \emph{Journal of Clinical Epidemiology} 2012; \bold{65}: 503--510.
\item Higgins JPT, Thompson SG. Quantifying heterogeneity in a meta-analysis. \emph{Statistics in Medicine} 2002; 
\bold{21}: 1539--1558.
\item Higgins JPT, Thompson SG, Spiegelhalter DJ. A re-evaluation of random-effects meta-analysis. 
\emph{Journal of the Royal Statistical Society. Series A (Statistics in Society)} 2009, \bold{172}: 137--159.
\item Riley RD, Higgins JPT, Deeks JJ. Interpretation of random effects meta-analyses. 
\emph{British Medical Journal} 2011; \bold{342}: d549.
\item Viechtbauer W. Conducting Meta-Analyses in R with the metafor Package. \emph{Journal of Statistical Software}. 
2010; 36(3). Available from: \url{http://www.jstatsoft.org/v36/i03/}
}
}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
\keyword{fixed-effect}
\keyword{heterogeneity}
\keyword{meta-analysis}
\keyword{random-effects}
\keyword{univariate}
