% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riley.r
\name{logLik.riley}
\alias{logLik.riley}
\title{Print the log-likelihood}
\usage{
\method{logLik}{riley}(object, ...)
}
\arguments{
\item{object}{A \code{riley} object, representing a fitted alternative model for bivariate random-effects 
meta-analysis when the within-study correlations are unknown.}

\item{\dots}{Additional arguments to be passed on to other functions, currently ignored.}
}
\value{
Returns an object of class \code{logLik}. This is the (restricted) log-likelihood of the model represented 
by \code{object} evaluated at the estimated coefficients. It contains at least one attribute, 
"\code{df}" (degrees of freedom), giving the number of (estimated) parameters in the model.
}
\description{
This function provides the (restricted) log-likelihood of a fitted model.
}
\examples{
data(Daniels)
fit <- riley(Daniels,control=list(maxit=10000))
logLik(fit)

}
\references{
Riley RD, Thompson JR, Abrams KR. An alternative model for bivariate random-effects meta-analysis when 
the within-study correlations are unknown. \emph{Biostatistics} 2008; \bold{9}: 172--186.
}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
\keyword{bivariate}
\keyword{likelihood}
\keyword{meta-analysis}
\keyword{riley}
