% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_utils.r
\name{plot.mm_perf}
\alias{plot.mm_perf}
\title{Forest Plots}
\usage{
\method{plot}{mm_perf}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"mm_perf"}}

\item{\ldots}{Additional arguments which are passed to \link{forest}.}
}
\value{
An object of class \code{ggplot}
}
\description{
Function to create forest plots for objects of class \code{"mm_perf"}.
}
\details{
The forest plot shows the performance estimates of each study with corresponding confidence 
intervals.
}
\examples{
data(EuroSCORE)

# Calculate the c-statistic and its standard error
est1 <- ccalc(cstat = c.index, cstat.se = se.c.index, cstat.cilb = c.index.95CIl, 
              cstat.ciub = c.index.95CIu, N = n, O = n.events, data = EuroSCORE, slab = Study)
plot(est1)

# Calculate the total O:E ratio and its standard error
est2 <- oecalc(O = n.events, E = e.events, N = n, data = EuroSCORE, slab = Study)
plot(est2)

}
\references{
Lewis S, Clarke M. Forest plots: trying to see the wood and the trees. \emph{BMJ}. 2001; 322(7300):1479--80.
}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
\keyword{forest}
