% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valmeta.r
\name{dplot.valmeta}
\alias{dplot.valmeta}
\title{Plot the prior and posterior distribution of a meta-analysis model}
\usage{
\method{dplot}{valmeta}(x, par, distr_type, plot_type = "dens", ...)
}
\arguments{
\item{x}{An object of class \code{"valmeta"}}

\item{par}{Character string to specify for which parameter a plot should be generated. Options are \code{"mu"} 
(mean of the random effects model) and \code{"tau"} (standard deviation of the random effects model).}

\item{distr_type}{Character string to specify whether the prior distribution (\code{"prior"}) or 
posterior distribution (\code{"posterior"}) should be displayed.}

\item{plot_type}{Character string to specify whether a density plot (\code{"dens"}) or 
histogram (\code{"hist"}) should be displayed.}

\item{\ldots}{Additional arguments which are currently not used}
}
\value{
An object of class \code{ggplot}
}
\description{
Function to generate plots for the prior and posterior distribution of a Bayesian meta-analysis.
}
\examples{
\dontrun{
data(EuroSCORE)

# Meta-analysis of the concordance statistic
fit <- valmeta(cstat=c.index, cstat.se=se.c.index, cstat.cilb=c.index.95CIl,
               cstat.ciub=c.index.95CIu, N=n, O=n.events, 
               data=EuroSCORE, method="BAYES", slab=Study)
dplot(fit)
dplot(fit, distr_type = "posterior")
dplot(fit, par = "tau", distr_type = "prior")

# Meta-analysis of the O:E ratio
EuroSCORE.new <- EuroSCORE
EuroSCORE.new$n[c(1, 2, 5, 10, 20)] <-  NA
pars <- list(hp.tau.dist="dhalft",   # Prior for the between-study standard deviation
             hp.tau.sigma=1.5,       # Standard deviation for 'hp.tau.dist'
             hp.tau.df=3,            # Degrees of freedom for 'hp.tau.dist'
             hp.tau.max=10)          # Maximum value for the between-study standard deviation
fit2 <- valmeta(measure="OE", O=n.events, E=e.events, N=n, data=EuroSCORE.new,
                method="BAYES", slab=Study, pars=pars)
dplot(fit2, plot_type = "hist")
} 

}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
\keyword{density}
\keyword{distribution}
\keyword{meta-analysis}
