% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_na.R
\name{utils_na_zero}
\alias{utils_na_zero}
\alias{fill_na}
\alias{has_na}
\alias{remove_rows_na}
\alias{remove_cols_na}
\alias{select_cols_na}
\alias{select_rows_na}
\alias{replace_na}
\alias{random_na}
\alias{has_zero}
\alias{remove_rows_zero}
\alias{remove_cols_zero}
\alias{select_cols_zero}
\alias{select_rows_zero}
\alias{replace_zero}
\title{Utilities for handling with NA and zero values}
\usage{
fill_na(.data, ..., direction = "down")

has_na(.data)

remove_rows_na(.data, verbose = TRUE)

remove_cols_na(.data, verbose = TRUE)

select_cols_na(.data, verbose = TRUE)

select_rows_na(.data, verbose = TRUE)

replace_na(.data, ..., replacement = 0)

random_na(.data, prop)

has_zero(.data)

remove_rows_zero(.data, verbose = TRUE)

remove_cols_zero(.data, verbose = TRUE)

select_cols_zero(.data, verbose = TRUE)

select_rows_zero(.data, verbose = TRUE)

replace_zero(.data, ..., replacement = NA)
}
\arguments{
\item{.data}{A data frame.}

\item{...}{Variables to fill  \code{NAs} in \code{fill_na()}, replace
\code{NAs} in \code{replace_na()} or zeros in \code{replace_zero()}. If
\code{...} is null then all variables in \code{.data} will be evaluated. It
must be a single variable name or a comma-separated list of unquoted
variables names. Select helpers are also allowed.}

\item{direction}{Direction in which to fill missing values. Currently either
"down" (the default), "up", "downup" (i.e. first down and then up) or
"updown" (first up and then down).}

\item{verbose}{Logical argument. If \code{TRUE} (default) shows in console
the rows or columns deleted.}

\item{replacement}{The value used for replacement. Defaults to \code{0}. Use
\code{replacement. = "colmean"} to replace missing values with column mean.}

\item{prop}{The proportion (percentage) of \code{NA} values to generate in
\code{.data}.}
}
\value{
A data frame with rows or columns with \code{NA} values deleted.
}
\description{
NAs and zeros can increase the noise in multi-environment trial
analysis. This collection of functions will make it easier to deal with
them.

\itemize{
\item \code{fill_na()}: Fills \code{NA} in selected columns using the next or
previous entry.
\item \code{has_na(), has_zero()}: Check for \code{NAs} and \code{0s} in the
data and return a logical value.
\item \code{random_na()}: Generate random \code{NA} values in a two-way table
based on a desired proportion.
\item \code{remove_cols_na(), remove_cols_zero()}: Remove columns with \code{NAs}
and \code{0s}, respectively.
\item \code{remove_rows_na(), remove_rows_zero()}: Remove rows with \code{NAs}
and \code{0s}, respectively.
\item \code{select_cols_na(), select_cols_zero()}: Select columns with \code{NAs}
and \code{0s}, respectively.
\item \code{select_rows_na(), select_rows_zero()}: Select rows with \code{NAs}
and \code{0s}, respectively.
\item \code{replace_na(), replace_zero()}: Replace \code{NAs} and \code{0s},
respectively, with a \code{replacement} value.
}
}
\examples{
\donttest{
library(metan)
data_naz <- iris \%>\%
              group_by(Species) \%>\%
              doo(~head(., n = 3)) \%>\%
              as_character(Species)
data_naz
data_naz[c(2:3, 6, 8), c(1:2, 4, 5)] <- NA
data_naz[c(2, 7, 9), c(2, 3, 4)] <- 0
has_na(data_naz)
has_zero(data_naz)

# Fill NA values of column GEN
fill_na(data_naz, Species)

# Remove columns
remove_cols_na(data_naz)
remove_cols_zero(data_naz)
remove_rows_na(data_naz)
remove_rows_zero(data_naz)

# Select columns
select_cols_na(data_naz)
select_cols_zero(data_naz)
select_rows_na(data_naz)
select_rows_zero(data_naz)

# Replace values
replace_na(data_naz)
replace_zero(data_naz)
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
