% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{is_balanced_trial}
\alias{is_balanced_trial}
\title{Check if a data set is balanced}
\usage{
is_balanced_trial(.data, env, gen, resp)
}
\arguments{
\item{.data}{The dataset containing the columns related to Environments,
Genotypes, replication/block and response variable(s).}

\item{env}{The name of the column that contains the levels of the
environments.}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{resp}{The response variable.}
}
\value{
A logical value
}
\description{
Check if a data set coming from multi-environment trials is balanced, i.e.,
all genotypes are in all environments.
}
\examples{
\donttest{
unb <- data_ge \%>\%
        remove_rows(1:3) \%>\%
        droplevels()
is_balanced_trial(data_ge, ENV, GEN, GY)
is_balanced_trial(unb, ENV, GEN, GY)
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
