% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scores.R
\name{plot_scores}
\alias{plot_scores}
\title{Plot scores in different graphical interpretations}
\usage{
plot_scores(
  x,
  var = 1,
  type = 1,
  first = "PC1",
  second = "PC2",
  repel = TRUE,
  repulsion = 1,
  max_overlaps = 20,
  polygon = FALSE,
  title = TRUE,
  plot_theme = theme_metan(),
  axis.expand = 1.1,
  x.lim = NULL,
  y.lim = NULL,
  x.breaks = waiver(),
  y.breaks = waiver(),
  x.lab = NULL,
  y.lab = NULL,
  shape.gen = 21,
  shape.env = 23,
  size.shape.gen = 2.2,
  size.shape.env = 2.2,
  size.bor.tick = 0.3,
  size.tex.lab = 12,
  size.tex.gen = 3.5,
  size.tex.env = 3.5,
  size.line = 0.5,
  size.segm.line = 0.5,
  col.bor.gen = "black",
  col.bor.env = "black",
  col.line = "black",
  col.gen = "blue",
  col.env = "forestgreen",
  col.alpha.gen = 1,
  col.alpha.env = 1,
  col.segm.gen = transparent_color(),
  col.segm.env = "forestgreen",
  highlight = NULL,
  col.highlight = "red",
  col.alpha.highlight = 1,
  size.tex.highlight = 5.5,
  size.shape.highlight = 3.2,
  leg.lab = c("Env", "Gen"),
  line.type = "solid",
  line.alpha = 0.9,
  resolution = deprecated(),
  file.type = "png",
  export = FALSE,
  file.name = NULL,
  width = 8,
  height = 7,
  color = TRUE,
  ...
)
}
\arguments{
\item{x}{An object fitted with the functions \code{\link[=performs_ammi]{performs_ammi()}},
\code{\link[=waas]{waas()}}, \code{\link[=waas_means]{waas_means()}}, or \code{\link[=waasb]{waasb()}}.}

\item{var}{The variable to plot. Defaults to \code{var = 1} the first
variable of \code{x}.}

\item{type}{type of biplot to produce
\itemize{
\item \code{type = 1} The default. Produces an AMMI1 biplot (Y x PC1) to make
inferences related to stability and productivity.
\item \code{type = 2} Produces an AMMI2 biplot (PC1 x PC2) to make inferences
related to the interaction effects. Use the arguments \code{first} or
\code{second} to change the default IPCA shown in the plot.
\item \code{type = 3} Valid for objects of class \code{waas} or \code{waasb},
produces a biplot showing the GY x WAASB.
\item \code{type = 4} Produces a plot with the Nominal yield x Environment PC.
}}

\item{first, second}{The IPCA to be shown in the first (x) and second (y)
axis. By default, IPCA1 is shown in the \code{x} axis and IPCA2 in the
\code{y} axis. For example, use \code{second = "PC3"} to shown the IPCA3 in
the \code{y} axis.}

\item{repel}{If \code{TRUE} (default), the text labels repel away from each
other and away from the data points.}

\item{repulsion}{Force of repulsion between overlapping text labels. Defaults
to \code{1}.}

\item{max_overlaps}{Exclude text labels that overlap too many things. Defaults to 20.}

\item{polygon}{Logical argument. If \code{TRUE}, a polygon is drawn when
\code{type = 2}.}

\item{title}{Logical values (Defaults to \code{TRUE}) to include
automatically generated titles}

\item{plot_theme}{The graphical theme of the plot. Default is
\code{plot_theme = theme_metan()}. For more details, see
\code{\link[ggplot2:theme]{ggplot2::theme()}}.}

\item{axis.expand}{Multiplication factor to expand the axis limits by to
enable fitting of labels. Default is \code{1.1}.}

\item{x.lim, y.lim}{The range of x and y axes, respectively. Default is
\code{NULL} (maximum and minimum values of the data set). New values can be
inserted as \code{x.lim = c(x.min, x.max)} or \code{y.lim = c(y.min, y.max)}.}

\item{x.breaks, y.breaks}{The breaks to be plotted in the x and y axes,
respectively. Defaults to \code{waiver()} (automatic breaks). New values
can be inserted, for example, as \code{x.breaks = c(0.1, 0.2, 0.3)} or
\code{x.breaks = seq(0, 1, by = 0.2)}}

\item{x.lab, y.lab}{The label of x and y axes, respectively. Defaults to
\code{NULL}, i.e., each plot has a default axis label. New values can be
inserted as \code{x.lab = 'my label'}.}

\item{shape.gen, shape.env}{The shape for genotypes and environments
indication in the biplot. Default is \code{21} (circle) for genotypes and
\code{23} (diamond) for environments. Values must be between \code{21-25}:
\code{21} (circle), \code{22} (square), \code{23} (diamond), \code{24} (up
triangle), and \code{25} (low triangle).}

\item{size.shape.gen, size.shape.env}{The size of the shapes for genotypes and
environments respectively. Defaults to \code{2.2}.}

\item{size.bor.tick}{The size of tick of shape. Default is \code{0.3}. The
size of the shape will be \code{max(size.shape.gen, size.shape.env) + size.bor.tick}}

\item{size.tex.lab, size.tex.gen, size.tex.env}{The size of the text for axis
labels (Defaults to 12), genotypes labels, and environments labels
(Defaults to 3.5).}

\item{size.line}{The size of the line that indicate the means in the biplot.
Default is \code{0.5}.}

\item{size.segm.line}{The size of the segment that start in the origin of the
biplot and end in the scores values. Default is \code{0.5}.}

\item{col.bor.gen, col.bor.env}{The color of the shape's border for genotypes
and environments, respectively.}

\item{col.line}{The color of the line that indicate the means in the biplot.
Default is \code{'gray'}}

\item{col.gen, col.env}{The shape color for genotypes (Defaults to
\code{'blue'}) and environments (\code{'forestgreen'}). Must be length
one or a vector of colors with the same length of the number of
genotypes/environments.}

\item{col.alpha.gen, col.alpha.env}{The alpha value for the color for
genotypes and environments, respectively. Defaults to \code{NA}. Values must be
between \code{0} (full transparency) to \code{1} (full color).}

\item{col.segm.gen, col.segm.env}{The color of segment for genotypes (Defaults
to \code{transparent_color()}) and environments (Defaults to 'forestgreen'),
respectively. Valid arguments for plots with \code{type = 1} or \code{type = 2} graphics.}

\item{highlight}{Genotypes/environments to be highlight in the plot. Defaults
to \code{NULL}.}

\item{col.highlight}{The color for shape/labels when a value is provided in
\code{highlight.} Defaults to \code{"red"}.}

\item{col.alpha.highlight}{The alpha value for the color of the highlighted
genotypes. Defaults to \code{1}.}

\item{size.tex.highlight}{The size of the text for the highlighted genotypes.
Defaults to \code{5.5}.}

\item{size.shape.highlight}{The size of the shape for the highlighted
genotypes. Defaults to \code{3.2}.}

\item{leg.lab}{The labs of legend. Default is \code{Gen} and \code{Env}.}

\item{line.type}{The type of the line that indicate the means in the biplot.
Default is \code{'solid'}. Other values that can be attributed are:
\code{'blank'}, no lines in the biplot, \verb{'dashed', 'dotted', 'dotdash', 'longdash', and 'twodash'}.}

\item{line.alpha}{The alpha value that combine the line with the background
to create the appearance of partial or full transparency. Default is
\code{0.4}. Values must be between '0' (full transparency) to '1' (full
color).}

\item{resolution}{deprecated}

\item{file.type}{The type of file to be exported. Currently recognises the extensions
eps/ps, tex, pdf, jpeg, tiff, png (default), bmp, svg and wmf (windows only).}

\item{export}{Export (or not) the plot. Default is \code{FALSE}. If \code{TRUE}, calls the
\code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} function.}

\item{file.name}{The name of the file for exportation, default is
\code{NULL}, i.e. the files are automatically named.}

\item{width}{The width 'inch' of the plot. Default is \code{8}.}

\item{height}{The height 'inch' of the plot. Default is \code{7}.}

\item{color}{Should type 4 plot have colors? Default to \code{TRUE}.}

\item{...}{Currently not used.}
}
\value{
An object of class \verb{gg, ggplot}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Plot scores of genotypes and environments in different graphical
interpretations.

Biplots type 1 and 2 are well known in AMMI analysis. In the plot type 3, the
scores of both genotypes and environments are plotted considering the
response variable and the WAASB, an stability index that considers all
significant principal component axis of traditional AMMI models or all
principal component axis estimated with BLUP-interaction effects (Olivoto et
al. 2019). Plot type 4 may be used to better understand the well known
'which-won-where' pattern, facilitating the recommendation of appropriate
genotypes targeted for specific environments, thus allowing the exploitation
of narrow adaptations.
}
\examples{
\donttest{
library(metan)
# AMMI model
model <- waas(data_ge,
             env = ENV,
             gen = GEN,
             rep = REP,
             resp = everything())

# GY x PC1 for variable GY (default plot)
plot_scores(model)

# PC1 x PC2 (variable HM)
#
plot_scores(model,
            polygon = TRUE,            # Draw a convex hull polygon
            var = "HM",                # or var = 2 to select variable
            highlight = c("G1", "G2"), # Highlight genotypes 2 and 3
            type = 2)                  # type of biplot

# PC3 x PC4 (variable HM)
# Change size of plot fonts and colors
# Minimal theme
plot_scores(model,
           var = "HM",
           type = 2,
           first = "PC3",
           second = "PC4",
           col.gen = "black",
           col.env = "gray",
           col.segm.env = "gray",
           size.tex.gen = 5,
           size.tex.env = 2,
           size.tex.lab = 16,
           plot_theme = theme_metan_minimal())

# WAASB index
waasb_model <- waasb(data_ge, ENV, GEN, REP, GY)

# GY x WAASB
# Highlight genotypes 2 and 8
plot_scores(waasb_model,
            type = 3,
            highlight = c("G2", "G8"))
}
}
\references{
Olivoto, T., A.D.C. L{\'{u}}cio, J.A.G. da silva, V.S. Marchioro, V.Q. de
Souza, and E. Jost. 2019. Mean performance and stability in multi-environment
trials I: Combining features of AMMI and BLUP techniques. Agron. J.
111:2949-2960. \doi{10.2134/agronj2019.03.0220}
}
\seealso{
\code{\link[=plot_eigen]{plot_eigen()}}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
