% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waas.R
\name{plot.waas}
\alias{plot.waas}
\title{Several types of residual plots}
\usage{
\method{plot}{waas}(x, ...)
}
\arguments{
\item{x}{An object of class \code{waas}.}

\item{...}{Additional arguments passed on to the function
\code{\link[=residual_plots]{residual_plots()}}}
}
\description{
Residual plots for a output model of class \code{waas}. Seven types
of plots are produced: (1) Residuals vs fitted, (2) normal Q-Q plot for the
residuals, (3) scale-location plot (standardized residuals vs Fitted Values),
(4) standardized residuals vs Factor-levels, (5) Histogram of raw residuals
and (6) standardized residuals vs observation order, and (7) 1:1 line plot.
}
\examples{
\donttest{
library(metan)
model <- waas(data_ge, ENV, GEN, REP, GY)
plot(model)
plot(model,
     which = c(3, 5),
     nrow = 2,
     labels = TRUE,
     size.lab.out = 4)
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
