% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waas_means.R
\name{waas_means}
\alias{waas_means}
\title{Weighted Average of Absolute Scores}
\usage{
waas_means(
  .data,
  env,
  gen,
  resp,
  mresp = NULL,
  wresp = NULL,
  min_expl_var = 85,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{.data}{The dataset containing the columns related to Environments,
Genotypes, replication/block and response variable(s).}

\item{env}{The name of the column that contains the levels of the
environments.}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{resp}{The response variable(s). To analyze multiple variables in a
single procedure a vector of variables may be used. For example \code{resp = c(var1, var2, var3)}. Select helpers are also allowed.}

\item{mresp}{The new maximum value after rescaling the response variable. By
default, all variables in \code{resp} are rescaled so that de maximum value
is 100 and the minimum value is 0 (i.e., \code{mresp = NULL}). It must be a
character vector of the same length of \code{resp} if rescaling is assumed
to be different across variables, e.g., if for the first variable smaller
values are better and for the second one, higher values are better, then
\code{mresp = c("l, h")} must be used. Character value of length 1 will be
recycled with a warning message.}

\item{wresp}{The weight for the response variable(s) for computing the WAASBY
index. Must be a numeric vector of the same length of \code{resp}. Defaults
to 50, i.e., equal weights for stability and mean performance.}

\item{min_expl_var}{The minimum explained variance. Defaults to 85.
Interaction Principal Compoment Axis are iteractively retained up to the
explained variance (eigenvalues in the singular value decomposition of the
matrix with the interaction effects) be greather than or equal to
\code{min_expl_var}. For example, if the explained variance (in percentage)
in seven possible IPCAs are \verb{56, 21, 9, 6, 4, 3, 1}, resulting in a
cumulative proportion of \verb{56,  77,  86,  92,  96, 99, 100}, then
\code{p = 3}, i.e., three IPCAs will be used to compute the index WAAS.}

\item{verbose}{Logical argument. If \code{verbose = FALSE} the code is run
silently.}

\item{...}{Arguments passed to the function
\code{\link[=impute_missing_val]{impute_missing_val()}} for imputation of missing values in case
of unbalanced data.}
}
\value{
An object of class \code{waas_means} with the following items for each
variable:
\itemize{
\item \strong{model} A data frame with the response variable, the scores of all
Principal Components, the estimates of Weighted Average of Absolute Scores,
and WAASY (the index that consider the weights for stability and productivity
in the genotype ranking.
\item \strong{ge_means} A tbl_df containing the genotype-environment means.
\item \strong{ge_eff} A \emph{gxe} matrix containing the genotype-environment effects.
\item \strong{eigenvalues} The eigenvalues from the singular value decomposition
of the matrix withe the genotype-environment interaction effects.
\item \strong{proportion} The proportion of the variance explained by each IPCA.
\item \strong{cum_proportion} The cumulative proportion of the variance explained.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Compute the Weighted Average of Absolute Scores (Olivoto et al., 2019) based
on means for genotype-environment data as follows:
\loadmathjax
\mjsdeqn{WAAS_i = \sum_{k = 1}^{p} |IPCA_{ik} \times EP_k|/ \sum_{k =
1}^{p}EP_k}

where \mjseqn{WAAS_i} is the weighted average of absolute scores of the
\emph{i}th genotype; \mjseqn{PCA_{ik}} is the score of the \emph{i}th genotype
in the \emph{k}th IPCA; and \mjseqn{EP_k} is the explained variance of the \emph{k}th
IPCA for \emph{k = 1,2,..,p}, where \emph{p} is the number of IPCAs that
explain at least an amount of the genotype-interaction variance declared in
the argument \code{min_expl_var}.
}
\examples{
\donttest{
library(metan)
# Data with replicates
model <- waas(data_ge,
              env = ENV,
              gen = GEN,
              rep = REP,
              resp = everything())

# Based on means of genotype-environment data
data_means <- mean_by(data_ge, ENV, GEN)
model2 <- waas_means(data_ge,
                     env = ENV,
                     gen = GEN,
                     resp = everything())
# The index WAAS
get_model_data(model, what = "OrWAAS")
get_model_data(model2, what = "OrWAAS")

}

}
\references{
Olivoto, T., A.D.C. L{\'{u}}cio, J.A.G. da silva, V.S. Marchioro, V.Q. de
Souza, and E. Jost. 2019a. Mean performance and stability in
multi-environment trials I: Combining features of AMMI and BLUP techniques.
Agron. J. 111:2949-2960. \doi{10.2134/agronj2019.03.0220}
}
\seealso{
\code{\link[=waas]{waas()}} \code{\link[=waasb]{waasb()}}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
